﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace TimeServer
{
    class IniClass
    {
        public string path = Path.Combine(Environment.CurrentDirectory, "config.ini");

        [DllImport("kernel32")]
        private static extern long WritePrivateProfileString(string section,
            string key, string val, string filePath);
        [DllImport("kernel32")]
        private static extern int GetPrivateProfileString(string section,
                 string key, string def, StringBuilder retVal,
            int size, string filePath);

        /// <summary>
        /// INIFile Constructor.
        /// </summary>
        public IniClass()
        {
            // Existiert die Ini-Datei überhaupt?
            if (!File.Exists(path))
            {
                try
                {
                    this.IniWriteValue("Connection", "Port", "4000");
                    this.IniWriteValue("Connection", "Host", "127.0.0.1");
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Ini Datei konnte nicht erstellt werden!{0}{1}", Environment.NewLine, ex.Message);
                    Console.ReadKey();
                    throw;
                }
            }
            // Existieren alle benötigten Werte in der Ini-Datei? Wenn nein, dann schreibe die default Werte
            if (string.IsNullOrWhiteSpace(this.IniReadValue("Connection", "Port"))) // Server-Port
                IniWriteValue("Connection", "Port", "4000");

            if (string.IsNullOrWhiteSpace(this.IniReadValue("Connection", "Host"))) // Server-Host
                IniWriteValue("Connection", "Host", "127.0.0.1");
        }
        /// <summary>
        /// Write Data to the INI File
        /// </summary>
        /// <PARAM name="Section"></PARAM>
        /// Section name
        /// <PARAM name="Key"></PARAM>
        /// Key Name
        /// <PARAM name="Value"></PARAM>
        /// Value Name
        public void IniWriteValue(string Section, string Key, string Value)
        {
            WritePrivateProfileString(Section, Key, Value, this.path);
        }

        /// <summary>
        /// Read Data Value From the Ini File
        /// </summary>
        /// <PARAM name="Section"></PARAM>
        /// <PARAM name="Key"></PARAM>
        /// <PARAM name="Path"></PARAM>
        /// <returns></returns>
        public string IniReadValue(string Section, string Key)
        {
            StringBuilder temp = new StringBuilder(255);
            int i = GetPrivateProfileString(Section, Key, "", temp,
                                            255, this.path);
            return temp.ToString();

        }
    }
}
