﻿//#define serverHost
using System;
using System.Collections.Generic;
using System.IO;
using System.Net.Sockets;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text;
using System.Threading;

namespace TimeClient
{
    class Program
    {
        static string filesDirectory = Path.Combine(Environment.CurrentDirectory, "files"); // Der Ordner, wo übertragene Dateien gespeichert werden

        static void Main(string[] args)
        {
            if (!Directory.Exists(filesDirectory))
            {
                Directory.CreateDirectory(filesDirectory);
            }
            ServerConnection sc = new ServerConnection();           
            while(true)
            {
                if(!sc._connected)
                {

                    string login = "";
                    do
                    {
                        Console.WriteLine("Login: ");
                        login = Console.ReadLine();
                    } while (string.IsNullOrWhiteSpace(login));


                    sc.Connect(login);
                }
                    
            }
            
        }
    }

    class ServerConnection
    {
        // Network Stuff
        TcpClient _connection;
        NetworkStream inStream = null;
        public bool _connected = false;
        string loginName = "";

        // Heartbeat
        System.Timers.Timer heartbeatTimer = new System.Timers.Timer(5000); // Alle 30 Sekunden, wie auf dem Server // Debug alle 5 sek
        bool heartbeatReceived = true; // Wird beim Empfang einer HeartbeatNachricht auf true gesetzt und beim senden einer auf False

        // Threads
        Thread sendeThread;
        Thread empfangsThread;


        string filesDirectory = Path.Combine(Environment.CurrentDirectory, "files"); // Der Ordner, wo übertragene Dateien gespeichert werden

        public ServerConnection()
        {
            heartbeatTimer.Elapsed += HeartbeatTimer_Elapsed;
        }

        private void HeartbeatTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (heartbeatReceived)
            {
                heartbeatReceived = false;
            }
            else
            {
                _connection.Close();
                _connected = false;
                heartbeatTimer.Enabled = false;
                Console.WriteLine("Verbindung zum Server verloren!");

            }
        }

        /// <summary>
        /// Verbindet sich mit dem Server
        /// </summary>
        /// <param name="username">Loginname</param>
        public void Connect(String username)
        {
            TcpClient connection = new TcpClient();

            // Verbindung aufbauen
#if !serverHost
            do
            {
                Console.WriteLine("Ziel eingeben (IPv4:PORT):");
                string eingabe = Console.ReadLine();

                string[] eingabeSplittet = eingabe.Split(':');

                if(eingabeSplittet.Length == 2)
                {
                    string ip = eingabeSplittet[0];

                    if (int.TryParse(eingabeSplittet[1], out int _port))
                    {
                        try
                        {
                            connection.Connect(ip, _port);
                            _connected = true;
                        }
                        catch (Exception ex)
                        {
                            Console.WriteLine(ex.Message);
                        }
                    }
                }
            }
            while (!_connected);
#else
            connection.Connect("127.0.0.1", 4000);
            _connected = true;
#endif
            heartbeatReceived = true;
            _connection = connection;


            inStream = connection.GetStream();

            /* 
             * Wir konvertieren die Bytes des strings zu Base64, da wir dadurch keine Probleme bei der Darstellung von Sonderzeichen erhalten
             * Ferner können wir so auch Dateien einfach übertragen
             * Weitere Informationen:
             * https://de.wikipedia.org/wiki/Base64
             * https://social.msdn.microsoft.com/Forums/sqlserver/en-US/6a546be8-f36f-4cce-a061-4200e4685400/how-to-send-base64-string-to-my-server?forum=netfxbcl
             */
            empfangsThread = new Thread(new ThreadStart(Empfange));
            empfangsThread.Start();

            // Anmelde Daten an den Server übermitteln
            loginName = username;
            TimeServerLibrary.LoginNachricht loginNachricht = new TimeServerLibrary.LoginNachricht()
            {
                LOGIN_NAME = username,
                PC_NAME = Environment.MachineName
            };

            SendData(loginNachricht);

            /* ALT
            string login64 = Convert.ToBase64String(System.Text.Encoding.UTF8.GetBytes(username));
            Byte[] sendLogin = System.Text.Encoding.UTF8.GetBytes(login64);

            inStream.Write(sendLogin, 0, sendLogin.Length);
            */
            Console.WriteLine("Verbunden!");

            sendeThread = new Thread(new ThreadStart(Eingabe));
            sendeThread.Start();

            // Erst wenn alles ordnungsgemäß gestartet ist, dann darf erst der Heartbeat geprüft werden!
            // Heartbeat
            
            heartbeatTimer.Enabled = true;
            heartbeatReceived = true;
        }

        private void Eingabe()
        {
            while (_connected)
            {
                Console.WriteLine("Nachricht senden:");

                string message = Console.ReadLine();


                bool send = true;

                object nachrichtenObject = null;


                if (message.StartsWith("/w")) // Handelt es sich um eine private Message?
                {
                    string[] splittedMessage = message.Split(' ');

                    if (splittedMessage.Length < 3)
                    {
                        Console.WriteLine("Ungültige Syntax /w <VerbindungsID> <Nachricht>");
                        send = false;
                    }
                    else if (int.TryParse(splittedMessage[1], out int VerbindungsID)) // Nur wenn wir eine Zahl haben, haben wir eine gültige Nachricht
                    {
                        nachrichtenObject = new TimeServerLibrary.PrivateNachricht()
                        {
                            Nachricht = message.Substring(4 + splittedMessage[1].Length), // Starte die Nachricht erst nach /w <ID> -> /w + 2 Leerzeichen + Länge ID
                            Empfänger_ID = VerbindungsID,
                            VERSENDER_NAME = loginName
                        };
                    }
                    else // Keine ID
                    {
                        Console.WriteLine("Ungültige Syntax /w <VerbindungsID> <Nachricht>");
                        send = false;
                    }
                }
                else if(message.Equals("exit")) // User möchte die Verbindung trennen
                {
                    nachrichtenObject = new TimeServerLibrary.DisconnectNachricht();
                    Console.ForegroundColor = ((TimeServerLibrary.DisconnectNachricht)nachrichtenObject).FontColor;
                }
                else // Nachricht an Alle
                {

                    nachrichtenObject = new TimeServerLibrary.PublicNachricht()
                    {
                        nachricht = message,
                        VERSENDER_NAME = loginName
                    };

                    if (message.Contains("-f"))
                    {
                        string[] messageSplitted = message.Substring(message.IndexOf("-f")).Split(' ');
                        if (messageSplitted.Length >= 2)
                        {
                            string fileName = messageSplitted[1].Replace("\"", "");

                            if (File.Exists(fileName))
                            {

                                message = message.Replace(messageSplitted[0] + " " + messageSplitted[1], "");

                                // Nachträglich Parameter aus Nachricht löschen
                                ((TimeServerLibrary.PublicNachricht)nachrichtenObject).nachricht = message;


                                try
                                {
                                    byte[] _fileContent = File.ReadAllBytes(fileName);
                                    ((TimeServerLibrary.PublicNachricht)nachrichtenObject).fileContent = _fileContent;
                                    ((TimeServerLibrary.PublicNachricht)nachrichtenObject).fileType = Path.GetExtension(fileName);
                                    ((TimeServerLibrary.PublicNachricht)nachrichtenObject).filename = fileName;
                                }
                                catch (Exception ex)
                                {
                                    Console.WriteLine(ex.Message);
                                }
                            }
                            else
                            {
                                Console.WriteLine("Die Datei {0} konnte nicht gefunden werden", fileName);
                            }
                        }
                        else
                        {
                            Console.WriteLine("Format für Dateiübertragung ungültig. -f <Datei>");
                        }
                    }

                }

                if (send)
                {
                    SendData(nachrichtenObject);

                    //if(!_connected) // User hat den Befehl zum disconnecten eingegeben
                    //{
                    //    Disconnect();
                    //}
                }
            }
        }
        private void Empfange()
        {
            
            while (_connected)
            {
                try
                {
                    // Stream zum lesen holen
                    // Hole nächsten Zeitstring vom Server
                    // Reads NetworkStream into a byte buffer.
                    /*byte[] buffer = new byte[connection.ReceiveBufferSize];
                    int byte_count = inStream.Read(buffer, 0, (int)connection.ReceiveBufferSize);            
                    byte[] formated = new Byte[byte_count];
                    Array.Copy(buffer, formated, byte_count); //handle  the null characteres in the byte array
                    //formated = Convert.FromBase64String(Encoding.UTF8.GetString(formated)); // Wir dekodieren den Base64 String wieder zu einem ByteArray
                    */

                    List<byte> bytesReceived = new List<byte>();
                    while (_connection.Available > 0 && _connection.Connected)
                    {
                        byte[] nextByte = new byte[1];
                        _connection.Client.Receive(nextByte, 0, 1, SocketFlags.None);
                        bytesReceived.AddRange(nextByte);
                    }



                    string data = System.Text.Encoding.UTF8.GetString(bytesReceived.ToArray());

                    if (!string.IsNullOrWhiteSpace(data))
                    {
                        //time = time.Substring(0, time.IndexOf("\n\r")); // Wir wollen den Inhalt bis zum Delimiter!!!!

                        object nachricht = TimeServerLibrary.NachrichtenSerializer.DeserializeObject(data);
                        bool ausgabe = true;
                        
                        if (nachricht.GetType() == typeof(TimeServerLibrary.PublicNachricht))
                        {
                            TimeServerLibrary.PublicNachricht publicNachricht = nachricht as TimeServerLibrary.PublicNachricht;
                            Console.ForegroundColor = publicNachricht.fontColor;
                            if (!string.IsNullOrWhiteSpace(publicNachricht.VERSENDER_NAME))
                                data = publicNachricht.VERSENDER_NAME + ": " + publicNachricht.nachricht;
                            else
                                data = publicNachricht.nachricht;

                            if (publicNachricht.fileContent != null) // Der Nachricht hängt eine Datei an
                            {
                                try
                                {
                                    File.WriteAllBytes(Path.Combine(filesDirectory, Path.GetFileName(publicNachricht.filename)), publicNachricht.fileContent);
                                }
                                catch (Exception ex)
                                {
                                    Console.WriteLine(ex.Message);
                                }
                            }


                        }
                        else if (nachricht.GetType() == typeof(TimeServerLibrary.PrivateNachricht))
                        {
                            TimeServerLibrary.PrivateNachricht privateNachricht = nachricht as TimeServerLibrary.PrivateNachricht;
                            if(!String.IsNullOrWhiteSpace(privateNachricht.VERSENDER_NAME))
                                data = privateNachricht.VERSENDER_NAME + ": " + privateNachricht.Nachricht;
                            else
                                data = privateNachricht.Nachricht;

                            Console.ForegroundColor = ConsoleColor.Red;
                        }
                        else if (nachricht.GetType() == typeof(TimeServerLibrary.KickNachricht))
                        {
                            data = ((TimeServerLibrary.KickNachricht)nachricht).Nachricht;
                            _connected = false;
                            heartbeatTimer.Enabled = false;
                            sendeThread.Abort();
                        }
                        else if(nachricht.GetType() == typeof(TimeServerLibrary.HeartBeatNachricht)) // Uns erreicht ein Heartbeat des Servers
                        {
                            ausgabe = false; // User soll Heartbeat nicht angezeigt bekommen
                            heartbeatReceived = true;
                            ((TimeServerLibrary.HeartBeatNachricht)nachricht).empfangen = DateTime.Now;
                            //Console.WriteLine("Neue Heartbeatanfrage gesendet um {0}, empfangen um {1}", ((TimeServerLibrary.HeartBeatNachricht)nachricht).gesendet, ((TimeServerLibrary.HeartBeatNachricht)nachricht).empfangen);
                            // Zurück an den Absender
                            SendData(nachricht);
                        }
                        else // Jemand ist disconnected
                        {
                            data = ((TimeServerLibrary.DisconnectNachricht)nachricht).Username + " " + ((TimeServerLibrary.DisconnectNachricht)nachricht).Nachricht;
                            Console.ForegroundColor = ((TimeServerLibrary.DisconnectNachricht)nachricht).FontColor;
                        }

                        // Ausgabe in der Konsole
                        if (ausgabe)
                        {
                            Console.WriteLine(data);
                        }

                        Console.ResetColor();
                    }
                }
                catch (Exception ex)
                {

                    Console.WriteLine(ex.Message);
                    // Setze das Schleifen-Flag zurück
                    // wenn ein Fehler in der Kommunikation aufgetreten ist
                    _connected = false;
                }
            }
            // Schließe die Verbindung zum Server
            _connection.Close();
            _connection.Dispose();

        }
        /// <summary>
        /// Sendet ein Nachrichten Object an den Server
        /// </summary>
        /// <param name="nachricht">Ein Object eines NachrichtenTyps</param>
        private void SendData(object nachricht)
        {
            string message = TimeServerLibrary.NachrichtenSerializer.SerializeObject(nachricht);
            Byte[] sendMessage = System.Text.Encoding.UTF8.GetBytes(message);
            try
            {
                inStream.Write(sendMessage, 0, sendMessage.Length);

                if(nachricht.GetType() == typeof(TimeServerLibrary.DisconnectNachricht))
                    Disconnect();
            }
            catch (IOException ex)
            {
                if(ex.HResult == -2146232800) // Die Verbindung ist fehlgeschlagen, disconnecte
                {
                    Console.WriteLine("Verbindung zum Server verloren!");
                    Disconnect();
                }
                else
                {
                    Console.WriteLine(ex.Message);
                }
                
                
            }
            catch(Exception ex)
            {
                Console.WriteLine(ex.GetType());
                Console.ReadKey();
            }
        }

        private void Disconnect()
        {
            heartbeatTimer.Enabled = false;
            heartbeatTimer.Close();
            
            _connected = false;
            _connection.Close();
            empfangsThread.Abort();
            sendeThread.Abort();
        }
    }


}
