﻿Imports System.ComponentModel
Imports System.Net
Imports System.IO
Imports System.Threading

Public Class updateUI

    Private downloadURL As Uri = New Uri("https://sownloader.com/Sownloader.zip")
    Private WithEvents Web As New WebClient
    Private inidatei As New inidatei
    Private serverConnect As New connectToServer
    Private WithEvents Shell As New Process

#Region "Download"
    Private Sub DownloadSownloader()
        With Web
            .Headers("User-Agent") = "Mozilla/5.0"
            .Proxy = Nothing
            .DownloadFileAsync(downloadURL, My.Computer.FileSystem.SpecialDirectories.Temp & "\Sownloader.zip")
        End With
    End Sub
#End Region

#Region "Buttons"
    Private Sub btnLater_Click(sender As Object, e As EventArgs) Handles btnLater.Click
        Application.Exit()
    End Sub

    Private Sub btnSkip_Click(sender As Object, e As EventArgs) Handles btnSkip.Click
        inidatei.WertSchreiben("Information", "skipVersion", lblNewVersion.Text)
        Application.Exit()
    End Sub

    Private Sub btnDownload_Click(sender As Object, e As EventArgs) Handles btnDownload.Click
        For Each Process In System.Diagnostics.Process.GetProcessesByName("Sownloader")
            Process.Kill()
        Next
        DownloadSownloader()
        btnLater.Enabled = False
        btnDownload.Enabled = False
        btnSkip.Enabled = False
        btnCancel.Enabled = True
        lblProgress.Visible = True
        ProgressBarDownload.Visible = True
        btnCancel.Visible = True
        btnCancel.Text = "Cancel"
    End Sub

    Private Sub btnWebsite_Click(sender As Object, e As EventArgs) Handles btnWebsite.Click
        Process.Start("http://sownloader.com")
    End Sub

    Private Sub btnCancel_Click(sender As Object, e As EventArgs) Handles btnCancel.Click
        If btnCancel.Text = "Cancel" Then
            Web.CancelAsync()
            lblProgress.Text = "Update has been canceled."
            btnLater.Enabled = True
            btnDownload.Enabled = True
            btnSkip.Enabled = True
            btnCancel.Text = "Close"
        ElseIf btnCancel.Text = "Close"
            Application.Exit()
        End If
    End Sub

    Private Sub btnRunSownloader_Click(sender As Object, e As EventArgs) Handles btnRunSownloader.Click
        Process.Start(Path.Combine(Application.StartupPath, "Sownloader.exe"))
        Application.Exit()
    End Sub
#End Region

    Private Sub updateUI_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        If Directory.Exists(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData), "Sownloader")) = False Then
            'Create Sownloader folder in %appdata%
            Directory.CreateDirectory(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData), "Sownloader"))
            File.Create(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData), "config.ini"))
        End If
        serverConnect.getLatestSownloaderVersion()
        btnCancel.Enabled = False
        lblProgress.Visible = False
        ProgressBarDownload.Visible = False
        btnCancel.Visible = False
        lblVer.Text = Application.ProductVersion

        If inidatei.WertLesen("Information", "version") = Nothing Then
            lblInstalledVersion.Text = "Unknown"
            If File.Exists(Path.Combine(Application.StartupPath, "Sownloader.exe")) Then
                lblInstalledVersion.Text = FileVersionInfo.GetVersionInfo(Path.Combine(Application.StartupPath, "Sownloader.exe")).ProductVersion
            End If
        Else
            lblInstalledVersion.Text = inidatei.WertLesen("Information", "version")
        End If

        If inidatei.WertLesen("Information", "latestVersion") = Nothing Then
            lblNewVersion.Text = "Unknown"
        Else
            lblNewVersion.Text = inidatei.WertLesen("Information", "latestVersion")
        End If
    End Sub

    Private Sub Web_DownloadProgressChanged(sender As Object, e As DownloadProgressChangedEventArgs) Handles Web.DownloadProgressChanged
        ProgressBarDownload.Value = e.ProgressPercentage
        lblProgress.Text = "Downloading... " & "(" & e.ProgressPercentage & "%)"
    End Sub

    Private Sub Web_DownloadFileCompleted(sender As Object, e As AsyncCompletedEventArgs) Handles Web.DownloadFileCompleted
        Web.Dispose()
        If e.Cancelled Then
            lblProgress.Text = "Update has been canceled."
            ProgressBarDownload.Visible = False

        ElseIf e.Error Is Nothing
            Try
                'Update database server
                serverConnect.updateDatabase(inidatei.WertLesen("Information", "latestVersion"))

                Dim cu As New ClassUnzip(Path.Combine(My.Computer.FileSystem.SpecialDirectories.Temp, "Sownloader.zip"), Application.StartupPath)
                lblProgress.Text = "Download finished. Extract files..."
                AddHandler cu.UnzipFinishd, AddressOf Unziped
                cu.UnzipNow()

            Catch ex As Exception

            End Try
        Else
            lblProgress.Text = "Download failed. Please try again."
            ProgressBarDownload.Value = 0
            ProgressBarDownload.Visible = False
            btnCancel.Visible = False
            btnLater.Enabled = True
            btnDownload.Enabled = True
            btnSkip.Enabled = True
        End If
    End Sub

    Private Async Sub Unziped()
        lblProgress.Text = "Optimize Sownloader..."
        Await Task.Run(Function()
                           With Shell
                               .StartInfo.FileName = "rundll32.exe"
                               .StartInfo.Arguments = "InetCpl.cpl,ClearMyTracksByProcess 255"
                               .EnableRaisingEvents = True
                               .Start()
                               .WaitForExit()
                           End With
                           Return True
                       End Function)
        lblProgress.Text = "Sownloader has been successfully updated."
        btnCancel.Text = "Close"
        btnRunSownloader.Enabled = True
        btnRunSownloader.Visible = True
    End Sub
End Class
