﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net;
using System.IO;
using System.Text.RegularExpressions;

namespace TestConsole.com.download
{
    public class DownloadHandler
    {
        /// <summary>
        /// This bool controls the url entered by the user as a valid uri.
        /// </summary>
        /// <param name="uriName">Website URI as string</param>
        /// <returns>Returns true if url is valid and false if not.</returns>
        public bool ValidateUri(string uriName)
        {
            Console.WriteLine("Validating URL...\n----------------");
            if(!uriName.Contains("http:") && !uriName.Contains("https:"))
                uriName = "https://" + uriName;

            Uri validatedUri;
            bool result = Uri.TryCreate(uriName, UriKind.Absolute, out validatedUri) && (validatedUri.Scheme == Uri.UriSchemeHttp || validatedUri.Scheme == Uri.UriSchemeHttps);
            if (result)
            {
                //Default Smule-URLS
                //https://www.smule.com/recording/toremifasol-nobody-knows-the-trouble-ive-seen/2416676_735991394
                //-----12-------------3---------4---------------------------------------------5-----------------6
                //https://www.smule.com/p/2416676_735991394
                //-----12-------------3-4-----------------5------------------------------------------------------
                string[] tmpSplit = uriName.Split('/');               
                if (uriName.Contains("smule.com/recording") || uriName.Contains("smule.com/p") || uriName.Contains("smule.com/c") && tmpSplit.Length >= 5)
                {
                    Console.WriteLine("Requested website: " + uriName + "\nAmount of splits: " + tmpSplit.Length + "\nValid: TRUE\n----------------\nFetching song meta data....");
                    FetchMetaData(validatedUri);
                    return true;
                }
                else
                {
                    Console.WriteLine("Website: " + uriName);
                    return false;
                }

            }
            else
            {
                return false;
            }
                
        }

        private void FetchMetaData(Uri validUri)
        {
            HttpWebRequest metaWebRequest = (HttpWebRequest)WebRequest.Create(validUri);
            metaWebRequest.Credentials = CredentialCache.DefaultCredentials;

            HttpWebResponse metaWebResponse = (HttpWebResponse)metaWebRequest.GetResponse();

            Console.WriteLine("Content length is {0}", metaWebResponse.ContentLength);
            Console.WriteLine("Content type is {0}", metaWebResponse.ContentType);
            Console.WriteLine("Character set is {0}", metaWebResponse.CharacterSet);
            Console.WriteLine(metaWebResponse.Headers);

            //
            string streamPath = Path.Combine(Path.GetTempPath(), "SownloaderFileStream.html");
            try
            {
                //Get the content stream
                Stream receiveStream = metaWebResponse.GetResponseStream();
                StreamReader readStream = new StreamReader(receiveStream, Encoding.UTF8);
                string sourcecodeResponse = readStream.ReadToEnd();
                string videoResponse = "null";           
               
                metaWebResponse.Close();
                readStream.Close();

                //Audio
                Regex RgxMedia = new Regex(@"\042media_url\042\072\042(?<mediaURL>.*?)\042", RegexOptions.IgnoreCase);
                Match mediaMatch = RgxMedia.Match(sourcecodeResponse);
                //Video
                Regex RgxVideo = new Regex(@"\042video_media_mp4_url\042\072\042(?<videoURL>.*?)\042", RegexOptions.IgnoreCase);
                Match VideoMatch = RgxVideo.Match(sourcecodeResponse);

                if (VideoMatch.Groups["videoURL"].Value != "")
                    videoResponse = VideoMatch.Groups["videoURL"].Value;


                Console.WriteLine("Found meta data:\nAudio: " + mediaMatch.Groups["mediaURL"].Value + "\nVideo: " + videoResponse);
            }
            catch
            {
                Console.WriteLine("Error");
            }
           

        }

    }
}
