﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TestConsole.com.output;
using TestConsole.com.download;

namespace TestConsole.com.command
{
    public class Listener
    {
        
        public void Listen(string command)
        {
            string[] tmpSplit = command.Split(' ');
            if (tmpSplit == null || tmpSplit.Length <= 0)
                return;

            switch (tmpSplit[0])
            {
                case "help":
                    // \n = zeilenumbruch
                    Print.Out("Available commands:\n--------------------\nexit\ndownload <URL>\nhelp\nweb", true);
                    break;
                case "web":
                    Process.Start("https://sownloader.com");
                    break;
                case "download":


                    DownloadHandler downloadHandler = new DownloadHandler();
                    if (tmpSplit.Length == 2)
                        Print.Out("Website: " + downloadHandler.ValidateUri(tmpSplit[1]), true);
                    else
                        Print.Out("Unknown syntax of command <download>. Please enter a valid URL to a Smule performance afterwards.",true);
                    break;
                case "exit":
                    Environment.Exit(0);
                    break;
                default:
                    Print.Out("The command <" + command + "> does not exist! Type help for all available commands.", true);
                    break;
            }
        }

      
    }
}
