﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
using System.Net;

namespace Sownloader
{
    public partial class Welcome : Form
    {
        private string coverDirectoryPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "covers");
        // Vars for updater
        private string updateURL = "https://www.sownloader.com/downloads/update.bat";
        private string updatePath = Path.Combine(Application.StartupPath, "update.bat");
        FileHandler.Logfile lfg;


        public Welcome()
        {
            InitializeComponent();
            lblStatus.Parent = pbLogo;
            lblVersion.Parent = pbLogo;
            lblVersion.Text = Application.ProductVersion;

             lfg = new FileHandler.Logfile();
        }

        private void Welcome_Load(object sender, EventArgs e)
        {
            lblStatus.Text = "Update files...";
            try
            {
                File.Delete(updatePath);

                HttpWebRequest http = (HttpWebRequest)WebRequest.Create(new Uri(updateURL));
                http.UserAgent = "Sownloader " + Application.ProductVersion;
                WebResponse response = http.GetResponse();
                // Create file from stream in temp
                Stream stream = response.GetResponseStream();
                using (Stream s = File.Create(updatePath))
                {
                    stream.CopyTo(s);
                }
            }
            catch(WebException wex)
            {
                lfg.WriteLog(wex.Message, FileHandler.Logfile.LOGLEVEL.ERROR);
            }
            catch (Exception)
            { 
                throw;
            }

            if (!Directory.Exists(coverDirectoryPath))
            {
                try
                {
                    Directory.CreateDirectory(coverDirectoryPath);
                }
                catch (Exception ex)
                {
                    MessageBox.Show("Unable to create the directory." + Environment.NewLine
                        + coverDirectoryPath + Environment.NewLine + Environment.NewLine + "Error:" + 
                        Environment.NewLine + ex.Message, "Critical error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    lfg.WriteLog(ex.Message, FileHandler.Logfile.LOGLEVEL.ERROR);
                    Application.Exit();
                }
            }

            lblStatus.Text = "Searching for updates...";

            UpdateSearch updatesearch = new UpdateSearch();
            updatesearch.UpdateSearchFinished += Updatesearch_UpdateSearchFinished;
            updatesearch.SearchForUpdate();
        }

        private void Updatesearch_UpdateSearchFinished(object sender, EventArgs e)
        {
            lblStatus.Text = "Loading...";
            timerLoad.Enabled = true;
        }

        private void timerLoad_Tick(object sender, EventArgs e)
        {
            timerLoad.Enabled = false;
            Sownloader swn = new Sownloader();
            swn.Show();
            this.Hide();
        }
    }
}
