﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Security.Cryptography;

namespace Sownloader
{
    static class Hilfsklassen
    {
        /// <summary>
        /// Die Methode überprüft die SHA256 Checksumme von heruntergeladenen Dateien.
        /// </summary>
        /// <param name="filename">Datei zum überprüfen</param>
        /// <returns>SHA256 Checksumme</returns>
        public static string checkSHA256(string filename)
        {
            using (FileStream stream = File.OpenRead(filename))
            {
                var sha = new SHA256Managed();
                byte[] checksum = sha.ComputeHash(stream);
                return BitConverter.ToString(checksum).Replace("-", String.Empty).ToLower();
            }
        }
        /// <summary>
        /// This method generates a random string by pattern Chars.
        /// </summary>
        /// <param name="StringLenght">Length of the random string</param>
        /// <returns>A random string.</returns>
        public static string GenerateRandomString(int StringLenght)
        {
            string Chars = "abcdefghijklmnopqrstuvwxyz";
            string RandomString = "";
            Random rdm = new Random();

            for (int i = 0; i < StringLenght; i++)
            {
                RandomString += Chars[rdm.Next(Chars.Length)];
            }

            return RandomString;
        }
    }
}
