﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace Sownloader.FileHandler
{
    class Logfile
    {
        private string logfile_path = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "sownloader.log");

        public Logfile()
        {
            if(!File.Exists(logfile_path))
            {
                try
                {
                    var logfile = File.Create(logfile_path);
                    logfile.Close();
                    logfile.Dispose();
                    File.AppendAllText(logfile_path, "[INFORMATION - " + DateTime.Now + "] Created logfile");
                }
                catch (System.IO.IOException)
                {
                    Console.WriteLine("Unable to create logfile");
                }
                
            }
        }
        /// <summary>
        /// Append text to the sownloader.log
        /// </summary>
        /// <param name="message">The message</param>
        /// <param name="loglevel">The type of the message</param>
        public void WriteLog(string message, LOGLEVEL loglevel)
        {
            string log_message = Environment.NewLine;

            switch (loglevel)   
            {
                case LOGLEVEL.ERROR:
                    log_message += "[ERROR - ";
                    break;
                case LOGLEVEL.INFORMATION:
                    log_message += "[INFORMATION - ";
                    break;
                case LOGLEVEL.WARNING:
                    log_message += "[WARNING - ";
                    break;
                default:
                    break;
            }

            log_message += DateTime.Now + "] " + message;

            File.AppendAllText(logfile_path, log_message);
        }

        public enum LOGLEVEL { ERROR, INFORMATION, WARNING }
    }
}
