﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Runtime.InteropServices;

namespace Sownloader.FileHandler
{
    public class INIClass
    {
        private string path = Path.Combine(System.Windows.Forms.Application.StartupPath, "config.ini");
        public string DEFAULTPAGE, SAVEPATH, BITRATE, SKIPVERSION;
        public bool KEEPFOCUSED, SHOWID3WINDOW;

        [DllImport("kernel32")]
        private static extern long WritePrivateProfileString(string section,
            string key, string val, string filePath);
        [DllImport("kernel32")]
        private static extern int GetPrivateProfileString(string section,
                 string key, string def, StringBuilder retVal,
            int size, string filePath);

        /// <summary>
        /// INIFile Constructor.
        /// </summary>
        public INIClass()
        {
            if (!File.Exists(path))
                CreateDefaultIni();

            GetValues();
        }
        /// <summary>
        /// Write Data to the INI File
        /// </summary>
        /// <PARAM name="Section"></PARAM>
        /// Section name
        /// <PARAM name="Key"></PARAM>
        /// Key Name
        /// <PARAM name="Value"></PARAM>
        /// Value Name
        private void IniWriteValue(string Section, string Key, string Value)
        {
            WritePrivateProfileString(Section, Key, Value, this.path);
        }
        /// <summary>
        /// Read Data Value From the Ini File
        /// </summary>
        /// <PARAM name="Section"></PARAM>
        /// <PARAM name="Key"></PARAM>
        /// <PARAM name="Path"></PARAM>
        /// <returns></returns>
        private string IniReadValue(string Section, string Key)
        {
            StringBuilder temp = new StringBuilder(255);
            int i = GetPrivateProfileString(Section, Key, "", temp,
                                            255, this.path);
            return temp.ToString();
        }
        /// <summary>
        /// Die Methode speichert alle Einstellungen
        /// </summary>
        /// <param name="KeepFocused"></param>
        /// <param name="DefaultPage"></param>
        /// <param name="SavePath"></param>
        /// <param name="Bitrate"></param>
        /// <param name="ShowID3Window"></param>
        public void SaveValues(bool KeepFocused, string DefaultPage, string SavePath, string Bitrate, bool ShowID3Window)
        {
            IniWriteValue("Config", "KeepFocused", (KeepFocused ? "true" : "false"));
            IniWriteValue("Config", "default_page", DefaultPage);
            IniWriteValue("Config", "save_path", SavePath);
            IniWriteValue("Config", "bitrate", Bitrate);
            IniWriteValue("Config", "show_id3_window", (ShowID3Window ? "true" : "false"));
        }
        /// <summary>
        /// Die Methode erstellt die conifg.ini, sofern die Datei noch nicht existiert
        /// </summary>
        public void CreateDefaultIni()
        {
            //TODO: Bei neuen Versionen mit neuen Einstellungen hier einen Eintrag hinzufügen
            IniWriteValue("Config", "KeepFocused", "false");
            IniWriteValue("Config", "default_page", "https://smule.com");
            IniWriteValue("Config", "save_path", Environment.GetFolderPath(Environment.SpecialFolder.MyMusic));
            IniWriteValue("Config", "bitrate", "320k");
            IniWriteValue("Config", "show_id3_window", "true");
            IniWriteValue("Information", "version", System.Windows.Forms.Application.ProductVersion);
            IniWriteValue("Information", "latestVersion", System.Windows.Forms.Application.ProductVersion);
            IniWriteValue("Information", "skipVersion", "1.0.0");
        }
        /// <summary>
        /// Die Methode lädt alle Values aus der Config Datei
        /// </summary>
        private void GetValues()
        {
            //TODO: Bei neuen Versionen mit neuen Einstellungen hier einen Eintrag hinzufügen und auf Inhalt prüfen
            DEFAULTPAGE = (String.IsNullOrEmpty(IniReadValue("Config", "default_page")) ? "https://smule.com" : IniReadValue("Config", "default_page"));
            SAVEPATH = (String.IsNullOrEmpty(IniReadValue("Config", "save_path")) ? Environment.GetFolderPath(Environment.SpecialFolder.MyMusic) : IniReadValue("Config", "save_path"));
            BITRATE = (String.IsNullOrEmpty(IniReadValue("Config", "bitrate")) ? "320k" : IniReadValue("Config", "bitrate"));
            KEEPFOCUSED = (!String.IsNullOrEmpty(IniReadValue("Config", "KeepFocused")) && (IniReadValue("Config", "KeepFocused") == "true" || IniReadValue("Config", "KeepFocused") == "false") ? Convert.ToBoolean(IniReadValue("Config", "KeepFocused")) : false);
            SHOWID3WINDOW = (!String.IsNullOrEmpty(IniReadValue("Config", "show_id3_window")) && (IniReadValue("Config", "show_id3_window") == "true" || IniReadValue("Config", "show_id3_window") == "false") ? Convert.ToBoolean(IniReadValue("Config", "show_id3_window")) : false);
            SKIPVERSION = (String.IsNullOrEmpty(IniReadValue("Information", "skipVersion")) ? "1.0.0" : IniReadValue("Information", "skipVersion"));
        }
        /// <summary>
        /// Die Methode aktualisiert die Information für die neueste Version
        /// </summary>
        /// <param name="latestVersion"></param>
        public void UpdateVersionInformation(string latestVersion)
        {
            IniWriteValue("Information", "version", System.Windows.Forms.Application.ProductVersion);
            IniWriteValue("Information", "latestVersion", latestVersion);
        }

        public void UpdateSkipVersion(string version)
        {
            IniWriteValue("Information", "skipVersion", version);
        }
    }
}
