﻿using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using AufgabenServerLibrary.ServerConfig;
using System.ServiceProcess;


namespace ServerConfig
{
    public partial class Main : Form
    {
        ServerConfiguration cfg = new ServerConfiguration();

        private string ServiceName = "AufgabenServer";
        
        public Main()
        {
            InitializeComponent();

            if(ServiceInstaller.ServiceIsInstalled(ServiceName))
            {
                AppendInfo("Der AufgabenServer befindet sich derzeit im Status: " + ServiceInstaller.GetServiceStatus(ServiceName));
                btnStart.Enabled = (ServiceInstaller.GetServiceStatus(ServiceName) == ServiceState.Stopped);
                btnNeustart.Enabled = (ServiceInstaller.GetServiceStatus(ServiceName) != ServiceState.Stopped);
                btnStop.Enabled = (ServiceInstaller.GetServiceStatus(ServiceName) != ServiceState.Stopped);
                btnInstallDienst.Visible = false;
            }
            else
            {
                // Der Dienst ist nicht installiert
                btnStart.Enabled = false;
                btnStop.Enabled = false;
                btnNeustart.Enabled = false;
                btnUninstallDienst.Visible = false;
                AppendInfo("Der AufgabenServer Dienst ist nicht installiert!");
            }

            
            
        }

        private void AppendInfo(string text)
        {
            rtbInfo.AppendText(text + Environment.NewLine);
        }

        private void Main_Load(object sender, EventArgs e)
        {
            //MessageBox.Show(cfg.ServerKonfiguration.ServerPort.ToString());
        }

        private void btnServerkonfiguration_Click(object sender, EventArgs e)
        {
            Konfiguration_Form cfg_frm = new Konfiguration_Form();
            if(cfg_frm.ShowDialog() == DialogResult.Yes)
            {
                cfg.LoadConfig();
                MessageBox.Show("Die Server Einstellungen wurden erfolgreich bearbeitet. Der Server muss neugetsartet werden, damit die Änderungen wirksam werden.", "Neustart erforderlich", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }

        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            ServiceInstaller.StartService(ServiceName);
            AppendInfo("Der AufgabenServer wurde erfolgreich gestartet!");
            btnStop.Enabled = true;
            btnStart.Enabled = false;
            btnNeustart.Enabled = true;
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            ServiceInstaller.StopService(ServiceName);
            AppendInfo("Der AufgabenServer wurde erfolgreich heruntergefahren!");
            btnStop.Enabled = false;
            btnStart.Enabled = true;
            btnNeustart.Enabled = false;
        }

        private void btnInstallDienst_Click(object sender, EventArgs e)
        {
            OpenFileDialog findAufgabenServer = new OpenFileDialog()
            {
                DefaultExt = ".exe",
                FileName = "",
                Filter = "AufgabenServer.exe (*.exe)|*.exe"
            };

            if(findAufgabenServer.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    ServiceInstaller.InstallAndStart(ServiceName, ServiceName, findAufgabenServer.FileName);
                    btnStop.Enabled = true;
                    btnInstallDienst.Visible = false;
                    btnNeustart.Enabled = true;
                    AppendInfo("Der AufgabenServer wurde erfolgreich installiert und gestartet!");
                }
                catch (Exception ex)
                {
                    AppendInfo("Fehler bei Installation! " + ex.Message);
                }
                
            }
        }

        private void btnNeustart_Click(object sender, EventArgs e)
        {
            btnStop.Enabled = false;
            ServiceInstaller.StopService(ServiceName);
            ServiceInstaller.StartService(ServiceName);
            btnStop.Enabled = true;
            AppendInfo("Der Server wurde erfolgreich neugestartet");
        }

        private void btnUninstallDienst_Click(object sender, EventArgs e)
        {
            btnStart.Enabled = false;
            btnStop.Enabled = false;
            btnNeustart.Enabled = false;
            ServiceInstaller.Uninstall(ServiceName);
            btnUninstallDienst.Visible = false;
            btnInstallDienst.Visible = true;
            AppendInfo("Der Dienst wurde erfolgreich deinstalliert");
        }
    }
}
