﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using AufgabenServerLibrary.ServerConfig;
using FirebirdSql.Data.FirebirdClient;

namespace ServerConfig
{
    public partial class Konfiguration_Form : Form
    {
        ServerConfiguration cfg = new ServerConfiguration();
        FbConnectionStringBuilder sb;

        public Konfiguration_Form()
        {
            InitializeComponent();

            if(String.IsNullOrEmpty(cfg.ServerKonfiguration.ServerHost))
            {
                cbAuto.Checked = true;
                tbFixIP.Enabled = false;
            }
            else
            {
                tbFixIP.Text = cfg.ServerKonfiguration.ServerHost;
            }

            nudPort.Value = cfg.ServerKonfiguration.ServerPort;

            tbServer.Text = cfg.ServerKonfiguration.DbServer;
            tbDatenbank.Text = cfg.ServerKonfiguration.DbName;
            tbUser.Text = cfg.ServerKonfiguration.DbUser;
            tbPasswort.Text = cfg.ServerKonfiguration.DbPass;
        }

        private void cbAuto_CheckedChanged(object sender, EventArgs e)
        {
            tbFixIP.Enabled = !cbAuto.Checked;
        }

        private void btnSpeichern_Click(object sender, EventArgs e)
        {
            if (TestFirebirdConnection())
            {

                cfg.WriteKeyValue(new KeyValuePair<string, object>("ServerHost", (cbAuto.Checked) ? "" : tbFixIP.Text));
                cfg.WriteKeyValue(new KeyValuePair<string, object>("ServerPort", (int)nudPort.Value));
                cfg.WriteKeyValue(new KeyValuePair<string, object>("DbServer", tbServer.Text));
                cfg.WriteKeyValue(new KeyValuePair<string, object>("DbName", tbDatenbank.Text));
                cfg.WriteKeyValue(new KeyValuePair<string, object>("DbUser", tbUser.Text));
                cfg.WriteKeyValue(new KeyValuePair<string, object>("DbPass", tbPasswort.Text));

                using (FbConnection connection = new FbConnection(sb.ToString()))
                {
                    connection.Open();
                    string updatePortSQL = "UPDATE OR INSERT INTO KONFIGURATION (KEY_NAME, KEY_VALUE) VALUES ('SERVER_PORT', @NEW_PORT)"; // Wir machen hier ein Update or Insert, da bei einem Update die Datenbank ggf. nicht über den key SERVER_PORT verfügt, sofern die Konfiguration vor der Aufgabenplanung gestartet wurde.
                    FbCommand updatePortCMD = new FbCommand(updatePortSQL, connection);
                    updatePortCMD.Parameters.AddWithValue("@NEW_PORT", (int)nudPort.Value);
                    updatePortCMD.ExecuteNonQuery();
                    connection.Close();
                }
            }
            else
            {
                MessageBox.Show("Die Einstellungen konnten nicht gespeichert werden, da der Zugriff auf die Firebird Datenbank fehlgeschlagen ist.", "Datenbankverbindung fehlgeschlagen", MessageBoxButtons.OK, MessageBoxIcon.Error);
                this.DialogResult = DialogResult.None;
            }
        }

        private bool TestFirebirdConnection()
        {
            try
            {
                sb = new FbConnectionStringBuilder()
                {
                    DataSource = tbServer.Text,
                    Database = tbDatenbank.Text,
                    UserID = tbUser.Text,
                    Password = tbPasswort.Text
                };

                FbConnection connection = new FbConnection(sb.ToString());
                connection.Open();
                connection.Close();
                return true;

            }
            catch (Exception)
            {
                return false;
            }
        }

        private void nudPort_Enter(object sender, EventArgs e)
        {
            tbOptionInfo.Text = @"Der Port auf dem der Server gestartet werden soll. 

Der Port muss anschließend noch in der Firewall freigegeben werden.";
        }

        private void cbAuto_Enter(object sender, EventArgs e)
        {
            tbOptionInfo.Text = @"Die Autoeinstellung sorgt dafür, dass der Server beim Start automatisch alle verfügbaren IPs herraussucht und auf einer davon den Server startet.";
        }

        private void tbFixIP_Enter(object sender, EventArgs e)
        {
            tbOptionInfo.Text = @"Hinterlegen Sie hier eine Fixe IP Ihres Servers. Auf dieser wird der AufgabenServer dann gestartet.";
        }

        private void tbServer_Enter(object sender, EventArgs e)
        {
            tbOptionInfo.Text = @"Tragen Sie hier den Host Ihres Firebird Servers ein.

Sollte der Firebird Server auf dem selben Server laufen wie der AufgabenServer, dann können Sie hier localhost eintragen.";
        }

        private void tbDatenbank_Enter(object sender, EventArgs e)
        {
            tbOptionInfo.Text = @"Geben Sie hier den Pfad zur Aufgaben.FDB aus der Sicht des Servers an.";

            if(!String.IsNullOrWhiteSpace(tbServer.Text) && tbServer.Text.ToLower() == "localhost")
            {
                OpenFileDialog selectDB = new OpenFileDialog()
                {
                    DefaultExt = ".FDB",
                    FileName = "",
                    Filter = "Firebird Datenbank (*.fdb)|*.fdb"
                };
                if(selectDB.ShowDialog() == DialogResult.OK)
                {
                    tbDatenbank.Text = selectDB.FileName;
                }
            }
        }

        private void tbUser_Enter(object sender, EventArgs e)
        {
            tbOptionInfo.Text = @"Geben Sie hier den Usernamen der Datenbank an. Sofern Sie diesen nicht geändert haben lautet der Username SYSDBA";
        }

        private void tbPasswort_Enter(object sender, EventArgs e)
        {
            tbOptionInfo.Text = @"Geben Sie hier das Passwort der Datenbank an. Sofern Sie dieses nicht geändert haben lautet das Passwort masterkey";
        }
    }
}
