﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AufgabenServerLibrary
{
    
    // Gutes Interface Tutorial: https://www.youtube.com/watch?v=IQpss9YAc4g
    /// <summary>
    /// Das Protokoll als Schnittstelle. IServerProtokoll bildet den Grundstein des Aufgabenservers.
    /// Sollten Änderungen am Protokoll notwendig sein, dann muss ein weiteres Interface hinzugefügt werden, welches dann von dem 
    /// vorherigen alle Eigenschaften vererbt bekommt. Die neueste Protokoll-Revision wird dann an die Class vererbt. Dadurch wird garantiert,
    /// dass immer alle voherigen Protokolle auch in neuen Versionen unterstützt werden
    /// Bei Änderungen an den NachrichtenTypen kann ggf. die Kompatibilität verloren gehen!!!
    /// </summary>
    interface IServerProtokoll
    {
        NachrichtenTypen.LoginNachricht loginNachricht { get; set; }
        NachrichtenTypen.AufgabenNachricht aufgabenNachricht { get; set; }
        NachrichtenTypen.ServerNachricht serverNachricht { get; set; }
        NachrichtenTypen.EinstellungsNachricht einstellungsNachricht { get; set; }
        NachrichtenTypen.UserVerfügbarNachricht userVerfügbarNachricht { get; set; }
        NachrichtenTypen.ChatNachricht chatNachricht { get; set; }
    }
    /// <summary>
    /// Instanziert ein neues Hauptprotokoll zum versenden unterschiedlicher Nachrichten zwischen dem Aufgabenserver und der Aufgabenplanung
    /// WICHTIG: Es kann immer nur ein Nachrichtentyp versendet werden!
    /// </summary>
    [Serializable]
    public class ServerProtokoll : IServerProtokoll
    {
        public static Version ProtokollVersion = new Version(1, 0, 0, 0); // Die Revision des Protokolls

        public NachrichtenTypen.LoginNachricht loginNachricht { get; set; }
        public NachrichtenTypen.AufgabenNachricht aufgabenNachricht { get; set; }
        public NachrichtenTypen.ServerNachricht serverNachricht { get; set; }
        public NachrichtenTypen.EinstellungsNachricht einstellungsNachricht { get; set; }
        public NachrichtenTypen.UserVerfügbarNachricht userVerfügbarNachricht { get; set; }
        public NachrichtenTypen.ChatNachricht chatNachricht { get; set; }
    }
}
