﻿using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AufgabenServerLibrary.ServerConfig
{
    public class ServerConfiguration
    {
        private string reg_key_path = "SOFTWARE\\AufgabenServer"; // Der Pfad zu den Registrierungsschlüsseln für den Aufgabenserver

        /// <summary>
        /// Das Dictionary beinhaltet alle Key die wir auslesen möchten, samt default Key, sofern der Key nicht gefunden werden kann
        /// </summary>
        Dictionary<string, object> keys = new Dictionary<string, object>()
        {
            {"ServerHost", "" }, // Leer symbolisiert, dass der Host automatisch ermittelt wird
            {"ServerPort", 5698 },
            {"DbServer", "localhost" },
            {"DbName", "" },
            {"DbUser", "SYSDBA" },
            {"DbPass", "masterkey" }

        };

        ServerConfig serverConfig = new ServerConfig();

        public ServerConfig ServerKonfiguration
        {
            get
            {
                return this.serverConfig;
            }
        }

        public struct ServerConfig
        {
            public string ServerHost;
            public int ServerPort;
            public string DbServer;
            public string DbName;
            public string DbUser;
            public string DbPass;
        }

        public ServerConfiguration()
        {
            if (RegKeyExists())
            {
                LoadConfig();
            }
            else
            {
                // Erstelle Key
                CreateDefaultKey();
                LoadConfig();
            }
        }
        /// <summary>
        /// Die Methode lädt alle AufgabenServer Registry Keys
        /// </summary>
        public void LoadConfig()
        {
            foreach (KeyValuePair<string, object> config in keys)
            {
                // Schritt 1: Prüfen ob der Key existiert, wenn nicht, dann default Key setzen
                if (!KeyExists(config.Key))
                    WriteKeyValue(config);

                // Schritt 2: Key auslesen
                object keyValue = GetKeyValue(config.Key);

                // Schritt 3: Value zuweisen
                switch (config.Key)
                {
                    case "ServerHost":
                        serverConfig.ServerHost = keyValue.ToString();
                        break;
                    case "ServerPort":
                        serverConfig.ServerPort = (int)keyValue;
                        break;
                    case "DbServer":
                        serverConfig.DbServer = keyValue.ToString();
                        break;
                    case "DbName":
                        serverConfig.DbName = keyValue.ToString();
                        break;
                    case "DbUser":
                        serverConfig.DbUser = keyValue.ToString();
                        break;
                    case "DbPass":
                        serverConfig.DbPass = keyValue.ToString();
                        break;
                    default:
                        break;
                }
            }
        }

        /// <summary>
        /// Die Methode prüft, ob der Key mit Value existiert
        /// </summary>
        /// <param name="keyName">Der Name des zu überprüfendes Keys</param>
        /// <returns>True/False</returns>
        private bool KeyExists(string keyName)
        {
            return Registry.LocalMachine.OpenSubKey(reg_key_path).GetValue(keyName) != null;
        }
        /// <summary>
        /// Die Methode liest einen AufgabenServer Registry-Key aus
        /// </summary>
        /// <param name="keyName"></param>
        /// <returns></returns>
        private object GetKeyValue(string keyName)
        {
            RegistryKey key = Registry.LocalMachine.CreateSubKey(reg_key_path, true);
            return key.GetValue(keyName);
        }
        /// <summary>
        /// Die Methode schreibt einen AufgabenServer Key in die Registry
        /// </summary>
        /// <param name="keyValuePair"></param>
        public void WriteKeyValue(KeyValuePair<string, object> keyValuePair)
        {
            RegistryKey key = Registry.LocalMachine.CreateSubKey(reg_key_path, true);
            key.SetValue(keyValuePair.Key, keyValuePair.Value);
        }
        /// <summary>
        /// Die Methode prüft, ob Das Verzeichnis für den AufgabenServer Schlüssel existiert.
        /// </summary>
        /// <returns>True/False</returns>
        private bool RegKeyExists()
        {
            return Registry.LocalMachine.OpenSubKey(reg_key_path) != null;
        }
        /// <summary>
        /// Die Methode erstellt den default Schlüssel für den AufgabenServer samt default Werte
        /// </summary>
        private void CreateDefaultKey()
        {
            RegistryKey key = Registry.LocalMachine.CreateSubKey(reg_key_path, true);
            key.SetValue("ServerHost", "");
            key.SetValue("ServerPort", 5698);
            key.SetValue("DbServer", "localhost");
            key.SetValue("DbName", "");
            key.SetValue("DbUser", "SYSDBA");
            key.SetValue("DbPass", "masterkey");
        }
    }
}
