﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AufgabenServerLibrary.NachrichtenTypen
{
    /// <summary>
    /// Dieser Nachrichtentyp wird versendet, wenn sich globale Einstellungen verändern. Sobald der Client diesen Typ erhält, lädt er alle Einstellungen erneut
    /// </summary>
    [Serializable]
    public class EinstellungsNachricht {}
    /// <summary>
    /// Der Nachrichtentyp, der beim Login an den Server gesendet wird.
    /// </summary>
    [Serializable]
    public class LoginNachricht
    {
        public String USER_NAME = "";
        public int USER_ID = 0;
        public String PC_NAME = "";
        public Version ProtokollVersion = new Version(1, 0, 0, 0);
    }
    /// <summary>
    /// Dieser Nachrichtentyp wird gesendet, wenn eine AUfgabe in irgendeiner Form bearbeitet, gelöscht oder erstellt wird
    /// </summary>
    [Serializable]
    public class AufgabenNachricht 
    {
        public Int64 A_NR = 0; //Eindeutige ID der Aufgabe, durch Generator in FB übergeben wenn insert null
        
        // Brauchen wir zur Bestimmung der Node-Position
        public int ANLAGE_USERID = 0;  //User-ID dessen der die Aufgabe angelegt hat
        public DateTime ANLAGE_DATUM;  //Wann wurde diese Aufgabe angelegt
        public DateTime AUFGABE_START; //Wann soll die Aufgabe gestartet werden
        public DateTime AUFGABE_FAELLIG;  //Bis wann soll die Aufgabe erledigt sein
        public int AUFGABE_AN_ID = 0;  //Die ID des Users oder der Gruppe an die die Aufgabe vergeben wurde
        public String AUFGABE_AN_G_ODER_U = "U"; //G = Gruppe, U = USER, U Vorbelegt um zu Determinieren
        public int BEARBEITET_USERID = 0; //Welcher User bearbeitet die Aufgabe
        

        public bool erledigteAufgabe = false; // Der Indikator, damit wir wissen, dass eine Aufgabe in erledigt eingefügt wird

        public AufgabeAktion NachrichtenTyp = AufgabeAktion.Angelegt; 
    }
    /// <summary>
    /// Dieser Nachrichtentyp wird ausschließlich vom Server an den Clienten gesendet. Er enthält Informationen, die der Server dem Clienten mitteilen möchte
    /// </summary>
    [Serializable]
    public class ServerNachricht
    {
        public String _title = "";
        public String _nachricht = "";
    }
    /* NachrichtenTyp wird nicht mehr benötigt, da jedesmal geprüft wird, ob die Verbindung noch vorhanden ist. Dadurch ist die Verbindung weniger anfällig für Fehler!
    /// <summary>
    /// Dieser Nachrichtentyp wird sowohl vom Server, als auch dem Clienten versendet. Sie enthält Informationen zu Verzögerung der Verbindung
    /// </summary>
    [Serializable]
    public class HeartBeatNachricht
    {
        public DateTime gesendet = new DateTime(); // Der Zeitpunkt, wann der Server die Nachricht losgeschickt hat
        public DateTime empfangen = new DateTime(); // Der Zeitpunkt, wann der Client die Nachricht empfangen hat
    }*/

    /// <summary>
    /// Dieser Nachrichtentyp wird verwendet um die aktiven User aktuell zu halten. Er kann leer vom User angefragt werden oder per Timer vom Server verschickt werden
    /// </summary>
    [Serializable]
    public class UserVerfügbarNachricht
    {
        public Dictionary<string, int> VERBUNDENE_USERS = new Dictionary<string, int>(); // Alle derzeit am Server angemeldeten Users -> Für Chat
    }

    /// <summary>
    /// Dieser Nachrichtentyp definiert eine generelle Chatnachricht
    /// </summary>
    [Serializable]
    public class ChatNachricht
    {
        // USER_IDS des EMPFÄNGERS und SENDERS, User kann dadruch auf Server zugeordnet werden
        public int ABSENDER_ID;
        public int EMPFÄNGER_ID;

        // Werden vom Server übermittelt, dadurch sparen wir uns die Userklassen bis hin zur Chatform weiterzugeben
        public string ABSENDER_NAME;
        public string EMPFÄNGER_NAME;

        public string nachricht; // Die verschickte Nachricht
    }

    /// <summary>
    /// Um zu identifizieren, was mit der Nachricht beim Clienten geschehen soll
    /// Angelegte Gruppennachrichten müssen für alle in der aktiven Gruppenansicht geladen werden
    /// Bearbeitete müssen sowohl für Personen als auch für Gruppen neugeladen werden -> Beim wechsel zwischen Gruppe und User muss diese auch hinzugefügt werden, sofern ansicht meine Aufgaben
    /// Gelöschte Aufgaben müssen für jeden User, der Sie sieht entfernt werden
    /// Erledigte müssen ebenfalls entfernt werden, allerdings muss diese dann in die Ansicht bei erledigte erscheinen
    /// </summary>
    [Serializable]
    public enum AufgabeAktion { Angelegt, Bearbeitet, Gelöscht, Erledigt };
    
}
