﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text;
using System.Threading.Tasks;

namespace AufgabenServerLibrary
{
    public static class NachrichtenSerializer
    {
        /// <summary>
        /// Serialisiert ein Object - macht also einen Base64 Kodierten String raus. Dabei sind die Zeichen sicher - Umlaute etc. geschützt.
        /// </summary>
        /// <param name="o"></param>
        /// <returns></returns>
        public static string SerializeObject(object o)
        {
            if (!o.GetType().IsSerializable)
            {
                return null;
            }
            /* 
            * Wir konvertieren die Bytes des strings zu Base64, da wir dadurch keine Probleme bei der Darstellung von Sonderzeichen erhalten
            * Ferner können wir so auch Dateien einfach übertragen
            * Weitere Informationen:
            * https://de.wikipedia.org/wiki/Base64
            * https://social.msdn.microsoft.com/Forums/sqlserver/en-US/6a546be8-f36f-4cce-a061-4200e4685400/how-to-send-base64-string-to-my-server?forum=netfxbcl
            */
            using (MemoryStream stream = new MemoryStream())
            {
                new BinaryFormatter().Serialize(stream, o);
                return Convert.ToBase64String(stream.ToArray());
            }
        }

        /// <summary>
        /// Deserialisiert den empfangen Base64 String
        /// </summary>
        /// <param name="str">Der empfangen Base64 String</param>
        /// <param name="NTyp">Der NachrichtenTyp, der ja als erstes Zeichen übertragen wurde</param>
        /// <returns></returns>
        public static object DeserializeObject(string str)
        {
            byte[] bytes = Convert.FromBase64String(str);
            object ReturnObject;  //Da die Klasse generisch ist, müssen wir ein Objekt zurück geben

            using (MemoryStream stream = new MemoryStream(bytes))
            {
                BinaryFormatter formatter = new BinaryFormatter();

                ReturnObject = formatter.Deserialize(stream);

                return ReturnObject;
            }
        }
    }
}
