﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace AufgabenServer
{
    static class ServerLog
    {
        private static string _logfile = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments), "aufgaben-server.log");

        public static void WriteLine(String _message, LogTyp _logTyp)
        {
            try
            {
                string typInfo = "";

                switch (_logTyp)
                {
                    case LogTyp.INFO:
                        typInfo = "[INFO " + DateTime.Now + "] ";
                        break;
                    case LogTyp.FEHLER:
                        typInfo = "[FEHLER" + DateTime.Now + "] ";
                        break;
                    case LogTyp.WARNUNG:
                        typInfo = "[WARNUNG " + DateTime.Now + "] ";
                        break;
                    default:
                        break;
                }
                File.AppendAllText(_logfile, typInfo + _message + Environment.NewLine);
            }
            catch (IOException)
            {
                
            }
        }

        public enum LogTyp { INFO, FEHLER, WARNUNG }
    }
}
