﻿#if DEBUG
    #define TesteKarussell
#endif
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.NetworkInformation;
using System.Net.Sockets;
using System.ServiceProcess;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using AufgabenServerLibrary.ServerConfig;
using FirebirdSql.Data.FirebirdClient;

namespace AufgabenServer
{
    public partial class AufgabenService : ServiceBase
    {
        // Der Listener
        private static TcpListener listener = null;
        // Die Liste der laufenden Server-Threads
        private static ArrayList ClientThreads = new ArrayList();

        // Verbindungs Informationen
        private static int _port = 8080;
        private static string _host = "";
        private static int verbindungsID = 1; // Eindeutige Verbindungs ID
        private static ServerConfiguration cfg = new ServerConfiguration(); // Die Klasse stellt alle Informationen bereit zur Datenbank, Host, Port

        // Server Informationen
        public static Version ServerProtokollVersion = AufgabenServerLibrary.ServerProtokoll.ProtokollVersion; // Vom Server verwendete Protkollversion
        private static DateTime serverStarted;
        private static string[] commands = new string[] { "send", "kick", "stop", "uptime", "help", "list" }; // TODO: Dictionary mit Eräuterung
        public static byte delimiter = 0x13;

        private static List<ServerThread> clientsToDisconnect = new List<ServerThread>();

        private static String FBConnectionString = ""; // Der ConnectionString zur Firebird Datenbank
       
        Thread th;

        // Karussell Einstellungen
        int KARUSSELLMUSSAW = 20; // Gibt an, bei wie viel % Zeitdifferenz bis zur Erledigung der Aufgabe, die Karussellaufgabe angenommen werden muss!
        int KARUSSELLZEIT = 10; // Gibt an, nahc wie vielen Minuten wieder auf nicht zugewiesene Karussellaufgaben geprüft werden soll
        int LIMIT_ABLEHNUNGEN = 5; // Gibt an, wie oft eine Karussellaufgabe abgelehnt werden darf
        System.Timers.Timer KARUSSELL_TIMER = new System.Timers.Timer();

        public AufgabenService()
        {
            InitializeComponent();
        }

        private void LadeEinstellungen()
        {
            using (FbConnection connection = new FbConnection(FBConnectionString))
            {
                try
                {
                    connection.Open();
                    string getEinstellungenSQL = "SELECT * FROM KONFIGURATION";
                    FbCommand getEinstellungenCMD = new FbCommand(getEinstellungenSQL, connection);
                    FbDataReader reader = getEinstellungenCMD.ExecuteReader();

                    while (reader.Read())
                    {
                        switch (reader["KEY_NAME"].ToString())
                        {
                            case "KARUSSELLMUSSAW":
                                int.TryParse(reader["KEY_VALUE"].ToString(), out KARUSSELLMUSSAW);
                                break;
                            case "KARUSSELLZEIT":
                                int.TryParse(reader["KEY_VALUE"].ToString(), out KARUSSELLZEIT);
                                break;
                            case "LIMIT_ABLEHNUNGEN":
                                int.TryParse(reader["KEY_VALUE"].ToString(), out LIMIT_ABLEHNUNGEN);
                                break;
                            default:
                                break;
                        }
                    }

                    
                }
                catch (Exception ex)
                {
                    AufgabenServerEventLog.WriteEntry("Fehler beim laden der Karusselleinstellungen." + Environment.NewLine + "Fehler: " + ex.Message, EventLogEntryType.Error, 1);
                    ServerLog.WriteLine("Fehler beim laden der Karusselleinstellungen." + Environment.NewLine + "Fehler: " + ex.Message, ServerLog.LogTyp.FEHLER);
                    throw;
                }
                finally
                {
                    connection.Close();
                }
            }
        }

        protected override void OnStart(string[] args)
        {
            // Datenbankverbindung herstellen
            FbConnectionStringBuilder sb = new FbConnectionStringBuilder()
            {
                DataSource = cfg.ServerKonfiguration.DbServer,
                Database = cfg.ServerKonfiguration.DbName,
                UserID = cfg.ServerKonfiguration.DbUser,
                Password = cfg.ServerKonfiguration.DbPass
            };

            FBConnectionString = sb.ToString();

            try
            {
                using (FbConnection connection = new FbConnection(FBConnectionString))
                {
                    connection.Open();             
                    connection.Close();
                }
            }
            catch (Exception ex)
            {
                AufgabenServerEventLog.WriteEntry("Die Verbindung zum Firebird Server ist fehlgeschlagen." + Environment.NewLine
                    + "Fehler: " + ex.Message + Environment.NewLine
                    + "ConnectionString: " + FBConnectionString, EventLogEntryType.Error, 0);

                ServerLog.WriteLine("Die Verbindung zum Firebird Server ist fehlgeschlagen." + Environment.NewLine
                    + "Fehler: " + ex.Message + Environment.NewLine
                    + "ConnectionString: " + FBConnectionString, ServerLog.LogTyp.FEHLER);
                throw;
            }

            // Lade relevante Einstellungen aus der Datenbank
            LadeEinstellungen();

            // Timer vorbereiten
            KARUSSELL_TIMER.Interval = KARUSSELLZEIT * 60000; // Rechne Minuten in ms um
            KARUSSELL_TIMER.Elapsed += KARUSSELL_TIMER_Elapsed;
#if TesteKarussell
            KARUSSELL_TIMER.Interval = 20000; // Alle 20 sek
#endif
            KARUSSELL_TIMER.Enabled = true;

            // Server hochfahren
            List<IPAddress> iPAddresses = GetIPAddresses().ToList();

            if(iPAddresses.Count > 0)
            {
                _host = iPAddresses.First().ToString();
            }
            else
            {
                ServerLog.WriteLine("Der Server konnte nicht gestartet werden, da keine IP zur verfügung steht!", ServerLog.LogTyp.FEHLER);
                AufgabenServerEventLog.WriteEntry("Der Server konnte nicht gestartet werden, da keine IP zur verfügung steht!", EventLogEntryType.Error, 0);
                Environment.Exit(0);
            }

            _port = cfg.ServerKonfiguration.ServerPort;

            // Wir wollen ggf. auf eine angegebene IP hören!
            if(!String.IsNullOrWhiteSpace(cfg.ServerKonfiguration.ServerHost))
                _host = cfg.ServerKonfiguration.ServerHost;
            
            // Listener initialisieren und starten
            if (IsPortAvailable() && HatNetzwerkKarte())
            {
                try
                {
                    IPAddress iPAddress = IPAddress.Parse(_host);
                    listener = new TcpListener(iPAddress, _port);
                    listener.Start();
                }
                catch (Exception)
                {
                    Console.WriteLine("Der Server konnte unter der Adresse {0}:{1} nicht gestartet werden. Prüfen Sie die Einstellungen in der Config.ini Datei.", _host, _port);
                    ServerLog.WriteLine("Der Server konnte nicht auf der Adresse " + _host + ":" + _port + " gestartet werden", ServerLog.LogTyp.FEHLER);
                    AufgabenServerEventLog.WriteEntry("Der Server konnte unter der Adresse " + _host + ":" + _port + " nicht gestartet werden. Prüfen Sie die Einstellungen in der Config.ini Datei.", EventLogEntryType.Error, 1);
                    throw;
                }

                th = new Thread(new ThreadStart(Run));
                th.Start();

                serverStarted = DateTime.Now;
                Console.WriteLine("{0} - Der Server wurde gestartet und ist unter folgender Adresse erreichbar {1}:{2}", serverStarted, _host, _port);
                AufgabenServerEventLog.WriteEntry(serverStarted + " - Der Server wurde gestartet und ist unter folgender Adresse erreichbar " + _host + ":" + _port, EventLogEntryType.Information, 0);

                ServerLog.WriteLine("Der Server wurde auf der Adresse " + _host + ":" + _port + " gestartet", ServerLog.LogTyp.INFO);
            }
        }

        private void KARUSSELL_TIMER_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            // TODO: Prüfe auf Karussellaufgaben
            if(ClientThreads.Count > 0) // Wir brauchen nur suchen, sofern wir mindestens eine Verbindung haben
            {
                
                // TODO: ArrayListe kopieren, damit bei Änderungen der Liste nicht der Server crasht!
                DataTable KarussellAufgaben = new DataTable();

                using (FbConnection connection = new FbConnection(FBConnectionString))
                {
                    connection.Open();
                    string getAufgabenSQL = "SELECT A_NR FROM AUFGABEN WHERE KARUSSEL_AUFGABE = '1' AND AUFGABE_AN_G_ODER_U = 'G' AND BEARBEITET_USERID = 0";
                    FbCommand getAufgabenCMD = new FbCommand(getAufgabenSQL, connection);
                    FbDataAdapter adapter = new FbDataAdapter(getAufgabenCMD);
                    adapter.Fill(KarussellAufgaben);
                    connection.Close();
                }

                foreach (DataRow row in KarussellAufgaben.Rows)
                {
                    // TODO: Offene Fenster müssen noch geschlossen beim Client geschlossen werden, damit die Aufgabe nicht zweimal angenommen werden kann
                    // TODO: Gleiches gilt auch, wenn ein AUfgabe Bearbeitet versendet wird, der Empfänger aber noch das Frage Fenster hat!
                    // TODO: Zufälligen User auswählen, der die Aufgabe annehmen kann! Dabei die Punkte des Users Berücksichtigen!
                    Console.WriteLine(row["A_NR"]);
                }

            }
        }

        /// <summary>
        /// Zum debuggen des Dienstes
        /// </summary>
        /// <param name="args"></param>
        internal void TestStartupAndStop(string[] args)
        {
            this.OnStart(args);
            Console.ReadLine();
            this.OnStop();
        }

        /// <summary>
        /// Der Server-Thread, der neue TcpClients empfängt
        /// </summary>
        public void Run()
        {
            while (true)
            {
                // Wartet auf eingehenden Verbindungswunsch
                TcpClient c = listener.AcceptTcpClient();
                   
                // Initialisiert und startet einen Server-Thread
                // und fügt ihn zur Liste der Server-Threads hinzu
                ServerThread clientThread = new ServerThread(c)
                {
                    VerbindungsID = verbindungsID
                };

                verbindungsID++;
                AufgabenServerEventLog.WriteEntry(clientThread.IP + " hat eine Verbindung aufgebaut", EventLogEntryType.Information, 200);
                clientThread.ClientDisconnected += ClientThread_ClientDisconnected; // Event abonnieren
                ClientThreads.Add(clientThread);
            }
        }
        /// <summary>
        /// Das Event, dass gefeuert wird, wenn ein Client die Verbindung verliert oder disconnected -> Er wird dann aus der threads Liste entfernt
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ClientThread_ClientDisconnected(object sender, ClientEventArgs e)
        {
            AufgabenServerEventLog.WriteEntry(e.Client.IP + " hat die Verbindung getrennt", EventLogEntryType.Information, 201);
            ClientThreads.Remove(e.Client);

            // Neue Chatliste zusenden
            AufgabenServerLibrary.ServerProtokoll serverProtokoll = new AufgabenServerLibrary.ServerProtokoll()
            {
                userVerfügbarNachricht = new AufgabenServerLibrary.NachrichtenTypen.UserVerfügbarNachricht()
                {
                    VERBUNDENE_USERS = VerbundeneUser()
                }
            };

            SendMessage(serverProtokoll);

        }

        private int RankIpAddress(IPAddress addr)
        {
            int rankScore = 1000;

            if (addr.AddressFamily == AddressFamily.InterNetwork)
            {
                rankScore += 100;
            }

            // class A
            if (addr.ToString().StartsWith("10."))
            {
                rankScore += 100;
            }

            // class B
            if (addr.ToString().StartsWith("172.30."))
            {
                rankScore += 100;
            }

            // class C
            if (addr.ToString().StartsWith("192.168.1."))
            {
                rankScore += 100;
            }

            // local sucks
            if (addr.ToString().StartsWith("169."))
            {
                rankScore = 0;
            }

            return rankScore;
        }

       

        private IEnumerable<IPAddress> GetIPAddresses()
        {
            List<IPAddress> ipAddresses = new List<IPAddress>();

            IEnumerable<NetworkInterface> enabledNetInterfaces = NetworkInterface.GetAllNetworkInterfaces()
                .Where(nic => nic.OperationalStatus == OperationalStatus.Up);
            foreach (NetworkInterface netInterface in enabledNetInterfaces)
            {
                IPInterfaceProperties ipProps = netInterface.GetIPProperties();
                foreach (IPAddressInformation addr in ipProps.UnicastAddresses)
                {
                    // We're only interested in IPv4 addresses for now 
                    if (addr.Address.AddressFamily != AddressFamily.InterNetwork)
                        continue;

                    // Ignore loopback addresses (e.g., 127.0.0.1) 
                    if (IPAddress.IsLoopback(addr.Address))
                        continue;

                    if (!ipAddresses.Contains(addr.Address))
                    {
                        ipAddresses.Add(addr.Address);
                    }
                }
            }

            var ipSorted = ipAddresses.OrderByDescending(ip => RankIpAddress(ip)).ToList();
            return ipSorted;
        }

        protected override void OnStop()
        {
            // Listener stoppen
            listener.Stop();

            // Haupt-Server-Thread stoppen
            if(th != null && th.IsAlive)
                th.Abort();

            // Alle Server-Threads stoppen
            for (IEnumerator e = ClientThreads.GetEnumerator(); e.MoveNext();)
            {
                // Nächsten Server-Thread holen
                ServerThread st = (ServerThread)e.Current;

                Console.WriteLine("Trenne Verbindung: {0} - {1}", st.IP, st.USER_NAME);
                // und stoppen
                st.stop = true;
               
                while (st.isSendingData || st.isReceivingData)
                    Thread.Sleep(1000);
            }

        }


        /// <summary>
        /// Prüfen ob der vom Server verwendete Port bereits verwendet wird
        /// </summary>
        /// <returns></returns>
        private static bool IsPortAvailable()
        {
            IPGlobalProperties ipProperties = IPGlobalProperties.GetIPGlobalProperties();
            IPEndPoint[] ipEndPoints = ipProperties.GetActiveTcpListeners();

            foreach (IPEndPoint endPoint in ipEndPoints)
            {
                if (endPoint.Port == _port)
                {
                    return false;
                }

            }
            return true;
        }

        private static bool HatNetzwerkKarte()
        {
            return System.Net.NetworkInformation.NetworkInterface.GetIsNetworkAvailable();
        }

        public static Dictionary<string, int> VerbundeneUser()
        {
            Dictionary<string, int> _VerbundeneUser = new Dictionary<string, int>();

            // Wir kopieren die Arraylist, damit es bei Änderungen nicht zu einer Exception führt
            ArrayList userThreads = new ArrayList(ClientThreads);

            for (IEnumerator e = userThreads.GetEnumerator(); e.MoveNext();)
            {
                // Nächsten Server-Thread holen
                ServerThread st = (ServerThread)e.Current;
                if(!_VerbundeneUser.ContainsKey(st.USER_NAME))
                    _VerbundeneUser.Add(st.USER_NAME, st.USER_ID);
            }

            return _VerbundeneUser;
        }
        /// <summary>
        /// Die Methode sucht den Empfänger einer Nachricht und verschickt diese an ihm
        /// </summary>
        /// <param name="nachrichtenobject"></param>
        public static void SendeChatNachricht(AufgabenServerLibrary.ServerProtokoll nachrichtenobject)
        {
            var sucheEmpfänger =
                from ServerThread st in ClientThreads
                where st.USER_ID == nachrichtenobject.chatNachricht.EMPFÄNGER_ID
                select st;

            if(sucheEmpfänger.Count() == 1)
            {
                sucheEmpfänger.First().Broadcast(nachrichtenobject);
            }
            else
            {
                Console.WriteLine("Empfänger nicht gefunden.");
            }
        }
        /// <summary>
        /// Die EventArgs für Aktionen mit dem Serverthread, sodass man von außen auf den jeweiligen Thread zugreifen kann
        /// </summary>
        class ClientEventArgs : EventArgs
        {
            private ServerThread _client;
            private string _message;
            public ClientEventArgs(ServerThread client, string message)
            {
                this._client = client;
                this._message = message;
            }

            // Properties
            public ServerThread Client
            {
                get { return _client; }
            }

            public String Message
            {
                get { return _message; }
            }
        }

        class NachrichtenEventArgs : EventArgs
        {
            private byte[] bytes;

            public NachrichtenEventArgs(byte[] _bytes)
            {
                bytes = _bytes;
            }

            public byte[] Data
            {
                get{ return this.bytes; }
            }
        }

        /// <summary>
        /// Sendet ein Nachrichten Object an alle verbunden Clients
        /// </summary>
        /// <param name="message"></param>
        public static void SendMessage(object nachrichtenObject)
        {
            // Nachricht an alle verfügbaren CLients senden
            ArrayList empfänger = new ArrayList(ClientThreads);
            for (IEnumerator e = empfänger.GetEnumerator(); e.MoveNext();)
            {
                // Nächsten Server-Thread holen
                ServerThread st = (ServerThread)e.Current;

                st.Broadcast(nachrichtenObject);
            }
        }

        delegate void ClientEventHandler(object sender, ClientEventArgs e);
        /// <summary>
        /// Der Serverthread, der für jeden User erstellt wird und diesen handelt
        /// </summary>
        class ServerThread
        {
            private EventLog ServerThreadEventLog = new EventLog()
            {
                Log = "Application",
                Source = "AufgabenServerThread",
                MachineName = "."
            };

            // Stop-Flag
            public bool stop = false;

            // Flags für "Thread läuft"
            public bool isReceivingData = false;
            public bool isSendingData = false;

            // Die Verbindung zum Client
            private TcpClient connection = null;
            public bool IsConnected
            {
                get
                {
                    try // Wir Try-Catchen, weil beim Receive ggf. die Verbindung abbrechen kann!
                    {
                        if (connection != null && connection.Client != null && connection.Client.Connected)
                        {
                            /* pear to the documentation on Poll:
                                * When passing SelectMode.SelectRead as a parameter to the Poll method it will return 
                                * -either- true if Socket.Listen(Int32) has been called and a connection is pending;
                                * -or- true if data is available for reading; 
                                * -or- true if the connection has been closed, reset, or terminated; 
                                * otherwise, returns false
                                */

                            // Detect if client disconnected
                            if (connection.Client.Poll(0, SelectMode.SelectRead))
                            {
                                byte[] buff = new byte[1];
                                if (connection.Client.Receive(buff, SocketFlags.Peek) == 0)
                                {
                                    // Client disconnected
                                    return false;
                                }
                                else
                                {
                                    return true;
                                }
                            }

                            return true;
                        }
                        else
                        {
                            return false;
                        }
                    }
                    catch
                    {
                        return false;
                    }
                }
            }

            public event ClientEventHandler ClientDisconnected;
            
            // Daten zur Verbindung
            public IPAddress IP = null;
            public string USER_NAME = "";
            public String PC_NAME = "";
            public int USER_ID = 0;
            public Version ProtokollVersion = new Version(1, 0, 0, 0);
            public int VerbindungsID = 0; // Eindeutige ID der Verbindung
            private bool _connected = true; // Wenn eine neue Verbindung aufgebaut wird, ist diese standardmäßig aktiv
            public DateTime verbundenSeit = new DateTime();

            Thread mainThread;

            // Speichert die Verbindung zum Client und startet den Thread
            public ServerThread(TcpClient connection)
            {
                // Speichert die Verbindung zu Client,
                // um sie später schließen zu können
                this.connection = connection;
                
                IP = ((IPEndPoint)connection.Client.RemoteEndPoint).Address;
                // Initialisiert und startet den Thread
                mainThread = new Thread(Run);
                mainThread.Start();
                
                verbundenSeit = DateTime.Now;
            }

            protected virtual void OnMessageArrived(NachrichtenEventArgs e)
            {
                isReceivingData = false;
                // DEBUG Byteausgabe
                //Console.WriteLine("{0} Bytes von {1} empfangen", e.Data.Length + 1, (String.IsNullOrWhiteSpace(this.USER_NAME)) ? this.IP.ToString() : this.USER_NAME); // +1 da der Delimiter noch dazu kommen muss
                string data = Encoding.UTF8.GetString(e.Data);

                if (!string.IsNullOrWhiteSpace(data))
                {
                    object nachricht = AufgabenServerLibrary.NachrichtenSerializer.DeserializeObject(data);


                    if (nachricht.GetType() == typeof(AufgabenServerLibrary.ServerProtokoll))
                    {
                        // Caste die Nachricht als ServerProtokoll
                        AufgabenServerLibrary.ServerProtokoll serverProtokoll = nachricht as AufgabenServerLibrary.ServerProtokoll;

                        // Prüfe auf bekannte Nachrichtentypen
                        if (serverProtokoll.aufgabenNachricht != null) // Uns erreicht eine Benachrichtigung zu einer Aufgabe
                        {
                            ServerThreadEventLog.WriteEntry("Aufgabe " + serverProtokoll.aufgabenNachricht.A_NR + " Aktion: " + serverProtokoll.aufgabenNachricht.NachrichtenTyp, EventLogEntryType.Information, 100);
                            Console.WriteLine("Aufgabe {0} Aktion: {1}", serverProtokoll.aufgabenNachricht.A_NR, serverProtokoll.aufgabenNachricht.NachrichtenTyp);
                            SendMessage(serverProtokoll);
                        }
                        else if (serverProtokoll.loginNachricht != null) // Uns erreicht eine Loginanfrage am Server
                        {
                            this.USER_NAME = serverProtokoll.loginNachricht.USER_NAME;
                            this.PC_NAME = serverProtokoll.loginNachricht.PC_NAME;
                            this.USER_ID = serverProtokoll.loginNachricht.USER_ID;
                            this.ProtokollVersion = serverProtokoll.loginNachricht.ProtokollVersion;

                            if (ProtokollVersion < ServerProtokollVersion)
                            {
                                AufgabenServerLibrary.ServerProtokoll sendServerProtoll = new AufgabenServerLibrary.ServerProtokoll()
                                {
                                    serverNachricht = new AufgabenServerLibrary.NachrichtenTypen.ServerNachricht()
                                    {
                                        _title = "Veraltete Protokollversion der Aufgabenplanung",
                                        _nachricht = "Sie verwenden einen veralteten Clienten der Aufgabenplanung! Sie können diesen wie gewohnt weiter verwenden." + Environment.NewLine + "Bitte beachten Sie, dass ältere Versionen Fehler beim kommunizieren mit dem Aufgabenserver aufweisen können." + Environment.NewLine + "Wir empfehlen Ihnen die Aufgabenplanung zu aktualisieren." + Environment.NewLine +
                                        "Ihre angeforderte Protokollversion: " + this.ProtokollVersion + Environment.NewLine + "Vom Server verwendete Protokollversion: " + ServerProtokollVersion
                                    }
                                };
                                this.Broadcast(sendServerProtoll);
                            }
                            else if (ProtokollVersion > ServerProtokollVersion)
                            {
                                AufgabenServerLibrary.ServerProtokoll sendServerProtoll = new AufgabenServerLibrary.ServerProtokoll()
                                {
                                    serverNachricht = new AufgabenServerLibrary.NachrichtenTypen.ServerNachricht()
                                    {
                                        _title = "Veraltete Protokollversion des Aufgabenserver",
                                        _nachricht = "Sie verwenden einen veralteten Aufgabenserver! Sie können diesen wie gewohnt weiter verwenden." + Environment.NewLine + "Bitte beachten Sie, dass ältere Versionen Fehler beim kommunizieren mit dem Aufgabenserver aufweisen können." + Environment.NewLine + "Wir empfehlen Ihnen den Aufgabenserver zu aktualisieren." + Environment.NewLine +
                                        "Ihre angeforderte Protokollversion: " + this.ProtokollVersion + Environment.NewLine + "Vom Server verwendete Protokollversion: " + ServerProtokollVersion
                                    }
                                };
                                this.Broadcast(sendServerProtoll);
                            }

                            Console.WriteLine("{0} hat sich verbunden - PC-NAME: {1} - Protokollversion: {2}", USER_NAME, PC_NAME, ProtokollVersion);
                            ServerLog.WriteLine(USER_NAME + " hat sich verbunden.", ServerLog.LogTyp.INFO);

                            // Chatliste zusenden
                            AufgabenServerLibrary.ServerProtokoll sendServerProtokoll1 = new AufgabenServerLibrary.ServerProtokoll();

                            sendServerProtokoll1.userVerfügbarNachricht = new AufgabenServerLibrary.NachrichtenTypen.UserVerfügbarNachricht()
                            {
                                VERBUNDENE_USERS = VerbundeneUser()
                            };

                            AufgabenService.SendMessage(sendServerProtokoll1);

                        }
                        else if (serverProtokoll.serverNachricht != null)
                        {
                            // Typ gibt es zwar, Client kann diese Nachricht aber nicht senden!
                        }
                        else if (serverProtokoll.einstellungsNachricht != null) // Globale Einstellungen wurden verändert! Leite diese Information an alle verbunden Clients weiter
                        {
                            Console.WriteLine("Globale Einstellungen geändert");
                            SendMessage(serverProtokoll);
                        }
                        else if (serverProtokoll.userVerfügbarNachricht != null) // User fragt nach aktuell verbundenen Usern
                        {
                            serverProtokoll.userVerfügbarNachricht.VERBUNDENE_USERS = VerbundeneUser();
                            Console.WriteLine("Abruf der Chatliste");
                            this.Broadcast(serverProtokoll);
                        }
                        else if (serverProtokoll.chatNachricht != null) // Uns erreicht eine Chatnachricht, die müssen wir zum richtigen Empfänger weiterleiten
                        {
                            Console.WriteLine("Chatnachricht für (Empfänger: {0} ID: {1}) von (Absender: {2} ID: {3})", serverProtokoll.chatNachricht.EMPFÄNGER_NAME, serverProtokoll.chatNachricht.EMPFÄNGER_ID, serverProtokoll.chatNachricht.ABSENDER_NAME, serverProtokoll.chatNachricht.ABSENDER_ID);
                            SendeChatNachricht(serverProtokoll);
                        }
                        else
                        {
                            // Es handelt sich zwar um ein übermitteltes Serverprotokoll, allerdings haben wir bis hier hin keinen Inhalt gefunden
                            // Das bedeutet, dass uns ein Nachrichtentyp einer nicht unterstützen Revision erreicht hat!
                            Console.ForegroundColor = ConsoleColor.Yellow;
                            Console.WriteLine("Nicht unterstützen Nachrichtentyp empfangen. Führen Sie ein Update des Servers durch!");
                        }

                    }
                    else
                    {
                        // Uns erreicht ein unbekanntes Flugobject!
                        Console.ForegroundColor = ConsoleColor.Red;
                        Console.WriteLine("Empfang eines fremden Protokolls!");
                        Console.WriteLine("VERBINDUNGS-ID {0}; IP {1}", verbindungsID, IP);
                        Console.WriteLine("Trenne Verbindung...");
                        OnClientDisconnected(new ClientEventArgs(this, IP + " Verbindung wurde durch Server getrennt."));
                    }

                }
                Console.ResetColor();
            }

            /// <summary>
            /// Das Event, wenn ein User disconnected oder die Verbindung verliert.
            /// </summary>
            /// <param name="e"></param>
            protected virtual void OnClientDisconnected(ClientEventArgs e)
            {
                Console.WriteLine(e.Message, IP);
                ServerLog.WriteLine(e.Message, ServerLog.LogTyp.INFO);

                _connected = false;

                if (ClientDisconnected != null)
                    ClientDisconnected(this, e);

                connection.Close();

                System.Threading.Thread.CurrentThread.Abort();
            }

            /// <summary>
            /// Der eigentliche Thread -> Hier werden alle Daten des Clients empfangen. Sollte dabei die Verbindung beendet werden, dann wird der Client automatisch aus der Sendeliste entfernt.
            /// </summary>
            private void Run()
            {
                bool loop = true;
                List<byte> bytesReceived = new List<byte>(); // Die Liste darf nicht innerhalb der Schleife erstellt werden! Bei Langsamen Verbindungen kann es nämlich sein, dass uns immer nur ein Teil der Daten erreicht. dann würden wir nur einen Teil auslesen und direkt wieder löschen. So bleiben die Daten bestehen, bis der Delimiter bei uns ankommt!
                while (connection.Connected && loop && _connected)
                {
                    _connected = this.IsConnected;
                    while (connection.Available > 0 && connection.Connected) // Läuft nur, wenn die Verbindung auch wirklich Daten sendet -> Wenn Verbindung abbricht, dann gibt es hier auch kein Fehler, da connection.available 0 bleibt
                    {
                        isReceivingData = true;
                        byte[] nextByte = new byte[1];
                        connection.Client.Receive(nextByte, 0, 1, SocketFlags.None);
                        if (nextByte[0] != delimiter)
                        {
                            bytesReceived.AddRange(nextByte);
                        }
                        else
                        {
                            OnMessageArrived(new NachrichtenEventArgs(bytesReceived.ToArray()));
                            bytesReceived.Clear();
                        }
                    }
                    loop = !stop; // Wiederhole die Schleife so lange bis von außen der Stopwunsch kommt

                    Thread.Sleep(100); // Nach jedem Durchgang warten wir 100ms, damit die CPU Auslastung nicht durchs permanente Abfragen bis auf 100% ansteigt!
                }
                if (!stop) // Bei Stop wird die Verbindung erzwungen beendet
                {
                    OnClientDisconnected(new ClientEventArgs(this, "Client {0} hat die Verbindung getrennt."));
                }
            }
            /// <summary>
            /// Versendet ein Nachrichtenobject an den Clienten
            /// </summary>
            /// <param name="nachricht"></param>
            public void Broadcast(object nachrichtenObject)
            {
                string message = AufgabenServerLibrary.NachrichtenSerializer.SerializeObject(nachrichtenObject) + Encoding.UTF8.GetString(new byte[] { delimiter }); // Message Base64 kodieren

                byte[] data = Encoding.UTF8.GetBytes(message);

                while (isSendingData)
                {
                    Thread.Sleep(300);
                    Console.WriteLine("Warten auf Übetragung...");
                }
                isSendingData = true;
                try
                {
                    // DEBUG Byteausgabe
                    //Console.WriteLine("Sende {0} Bytes an {1}", data.Length, this.USER_NAME);
                    // Nachricht an Client senden
                    connection.GetStream().Write(data, 0, data.Length);
                }
                catch (Exception ex)
                {
                    ServerThreadEventLog.WriteEntry("Nachricht konnte nicht an Client gesendet werden " + ex.Message, EventLogEntryType.Error, 101);
                    ServerLog.WriteLine("Nachricht konnte nicht an Client gesendet werden " + ex.Message, ServerLog.LogTyp.FEHLER);
                    OnClientDisconnected(new ClientEventArgs(this, "Client {0} hat die Verbindung getrennt."));
                }
                finally
                {
                    isSendingData = false;
                }
            }

        }
    }
}
