﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace SchiffeVersenken
{
    class Spielfeld : Panel
    {
        protected override void SetBoundsCore(int x, int y,
   int width, int height, BoundsSpecified specified)
        {
            // Set a fixed height for the control.
            base.SetBoundsCore(x, y, 284, 284, specified);
        }

        public bool BearbeitungsModus { get; set; }
        public Schiff SchiffZuSetzen;

        public Feld[,] Felder = new Feld[10, 10];
        public Spielfeld()
        {
            int currentLocationX = 0; // Stellt die derzeitige X Location innerhalb des Panels dar
            int currentLocationY = 0; // Stellt die derzeitige Y Location innerhalb des Panels dar
            int position = 1; // Stellt die X-Position des Feldes in einer Reihe dar.
            int reihe = 1; // Stellt die Y-Position des Feldes in einer Reihe dar.
            for (int i = 1; i <= 100; i++)
            {

                Feld feld = new Feld(
                    owner: this,
                    location: new Point(currentLocationX, currentLocationY),
                    koordinaten: new Koordinaten(position, reihe)
                );

                Felder[position - 1, reihe - 1] = feld;

                currentLocationX += 28; // 28, da der Border jeweils 1px breit ist

                if (i % 10 == 0)
                {
                    currentLocationX = 0;
                    currentLocationY += 28;
                    reihe++;
                }
                position++;
                if (position == 11)
                    position = 1;
            }

            BearbeitungsModus = false;
        }

        public class Feld : PictureBox
        {
            public Koordinaten Koordinaten { get; private set; }

            public Feld(Spielfeld owner, Point location, Koordinaten koordinaten)
            {
                Size = new Size(30, 30);
                Parent = owner;
                BorderStyle = BorderStyle.FixedSingle;
                Location = location;
                this.Koordinaten = koordinaten;
            }

            protected override void OnMouseClick(MouseEventArgs e)
            {
                if(e.Button == MouseButtons.Right)
                {
                    Spielfeld spielfeld = Parent as Spielfeld;
                    if (spielfeld?.BearbeitungsModus == true)
                    {

                        // Freigeben
                        int arrX = Koordinaten.X - 1;
                        int arrY = Koordinaten.Y - 1;

                        switch (spielfeld.SchiffZuSetzen.Ausrichtung)
                        {
                            case Ausrichtung.Vertikal:
                                if (arrY + spielfeld.SchiffZuSetzen.Länge > 10)
                                    return;
                                break;
                            case Ausrichtung.Horizontal:
                                if (arrX + spielfeld.SchiffZuSetzen.Länge > 10)
                                    return;
                                break;
                            default:
                                break;
                        }

                        for (int i = 0; i < spielfeld.SchiffZuSetzen.Länge; i++)
                        {
                            spielfeld.Felder[arrX, arrY].BackColor = Color.White;
                            if (spielfeld.SchiffZuSetzen.Ausrichtung == Ausrichtung.Horizontal)
                                arrX++;
                            else
                                arrY++;
                        }

                        spielfeld.SchiffZuSetzen.Ausrichtung = (spielfeld.SchiffZuSetzen.Ausrichtung == Ausrichtung.Horizontal) ? Ausrichtung.Vertikal : Ausrichtung.Horizontal;

                        // Füllen
                        arrX = Koordinaten.X - 1;
                        arrY = Koordinaten.Y - 1;

                        switch (spielfeld.SchiffZuSetzen.Ausrichtung)
                        {
                            case Ausrichtung.Vertikal:
                                if (arrY + spielfeld.SchiffZuSetzen.Länge > 10)
                                    return;
                                break;
                            case Ausrichtung.Horizontal:
                                if (arrX + spielfeld.SchiffZuSetzen.Länge > 10)
                                    return;
                                break;
                            default:
                                break;
                        }

                        for (int i = 0; i < spielfeld.SchiffZuSetzen.Länge; i++)
                        {
                            spielfeld.Felder[arrX, arrY].BackColor = Color.Black;
                            if (spielfeld.SchiffZuSetzen.Ausrichtung == Ausrichtung.Horizontal)
                                arrX++;
                            else
                                arrY++;
                        }
                    }
                }
            }
            protected override void OnMouseLeave(EventArgs e)
            {
                Spielfeld spielfeld = Parent as Spielfeld;

                if (spielfeld?.BearbeitungsModus == true)
                {
                    int arrX = Koordinaten.X - 1;
                    int arrY = Koordinaten.Y - 1;

                    switch (spielfeld.SchiffZuSetzen.Ausrichtung)
                    {
                        case Ausrichtung.Vertikal:
                            if (arrY + spielfeld.SchiffZuSetzen.Länge > 10)
                                return;
                            break;
                        case Ausrichtung.Horizontal:
                            if (arrX + spielfeld.SchiffZuSetzen.Länge > 10)
                                return;
                            break;
                        default:
                            break;
                    }

                    for (int i = 0; i < spielfeld.SchiffZuSetzen.Länge; i++)
                    {
                        spielfeld.Felder[arrX, arrY].BackColor = Color.White;
                        if (spielfeld.SchiffZuSetzen.Ausrichtung == Ausrichtung.Horizontal)
                            arrX++;
                        else
                            arrY++;
                    }

                }
            }
            protected override void OnMouseHover(EventArgs e)
            {
                Spielfeld spielfeld = Parent as Spielfeld;

                if(spielfeld?.BearbeitungsModus == true)
                {
                    int arrX = Koordinaten.X - 1;
                    int arrY = Koordinaten.Y - 1;

                    switch (spielfeld.SchiffZuSetzen.Ausrichtung)
                    {
                        case Ausrichtung.Vertikal:
                            if (arrY + spielfeld.SchiffZuSetzen.Länge > 10)
                                return;
                            break;
                        case Ausrichtung.Horizontal:
                            if (arrX + spielfeld.SchiffZuSetzen.Länge > 10)
                                return;
                            break;
                        default:
                            break;
                    }

                    for (int i = 0; i < spielfeld.SchiffZuSetzen.Länge; i++)
                    {
                        spielfeld.Felder[arrX, arrY].BackColor = Color.Black;
                        if(spielfeld.SchiffZuSetzen.Ausrichtung == Ausrichtung.Horizontal)
                            arrX++;
                        else
                            arrY++;
                    }
                    
                }
            }

            protected override void OnClick(EventArgs e)
            {
                MessageBox.Show($"Position: {Environment.NewLine}X: {Koordinaten.X} Y: {Koordinaten.Y}");
            }
        }
    }
}
