﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SchiffeVersenken
{
    class Schiff
    {
        /// <summary>
        /// Ruft den Typen des Schiffs ab
        /// </summary>
        public SchiffsTyp Typ { get; private set; }
        /// <summary>
        /// Ruft die Länge des Schiffs ab.
        /// </summary>
        public int Länge { get; }
        public Koordinaten Position { get; private set; }
        /// <summary>
        /// Gibt an, ob das Schiff zerstört ist, oder nicht.
        /// </summary>
        public bool IstZerstört { get; private set; }
        /// <summary>
        /// Ruft die Ausrichtung des Schiffs ab.
        /// </summary>
        public Ausrichtung Ausrichtung { get; set; }

        public Schiff(SchiffsTyp typ)
        {
            this.Typ = typ;
            switch (Typ)
            {
                case SchiffsTyp.Schlachtschiff:
                    Länge = 5;
                    break;
                case SchiffsTyp.Kreuzer:
                    Länge = 4;
                    break;
                case SchiffsTyp.Zerstörer:
                    Länge = 3;
                    break;
                case SchiffsTyp.UBoot:
                    Länge = 2;
                    break;
                default:
                    break;
            }

            Ausrichtung = Ausrichtung.Horizontal;
            IstZerstört = false;
        }

        public bool SetPosition(Koordinaten koordinaten, Spielfeld spielfeld)
        {
            this.Position = koordinaten;
            return true;
        }



        
    }

    public enum SchiffsTyp
    {
        /// <summary>
        /// Ein Schlachtschiff (5 Kästchen)
        /// </summary>
        Schlachtschiff,
        /// <summary>
        /// Ein Kreizer (4 Kästchen)
        /// </summary>
        Kreuzer,
        /// <summary>
        /// Ein Zerstörer (3 Kästchen)
        /// </summary>
        Zerstörer,
        /// <summary>
        /// Ein U-boot (2 Kästchen)
        /// </summary>
        UBoot
    }

    public enum Ausrichtung
    {
        Vertikal,
        Horizontal
    }

    public struct Koordinaten
    {
        public int X;
        public int Y;

        public Koordinaten(int x, int y)
        {
            this.X = x;
            this.Y = y;
        }
    }
}
