﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Schiffeversenken
{
    class SchiffCl
    {
        public String Name;
        public Position[] Pos;
        public const int MaxXY = 9;
        public Boolean versenkt = false;

        public SchiffCl(String name, int länge)
        {
            Name = name;
            Pos = new Position[länge];
            for (int i = 0; i < länge; i++)
            {
                Position tmpPos = new Position()
                {
                    X = -1, //Außerhalb des Spielfeldes, damit an Feld 0 gesetzt werden kann
                    Y = -1, //Außerhalb des Spielfeldes, damit an Feld 0 gesetzt werden kann
                    Getroffen = false
                };
                Pos[i] = tmpPos;
            }
        }

        public bool SetzeSchiff(int PosX, int PosY, Ausrichtung ausrichtung, List<SchiffCl> meineSchiffe)
        {
            Boolean KannIchSoSetzen = true;
            
            if(ausrichtung == Ausrichtung.horizontal)
            {
                if (PosX + Pos.Length > MaxXY)
                    KannIchSoSetzen = false;
            }
            if(ausrichtung == Ausrichtung.vertikal)
            {
                if (PosY + Pos.Length > MaxXY)
                    KannIchSoSetzen = false;
            }
            /* Setze die Position für das
            * aktuelle Schiff, um diese
            * mit den anderen zu vergleichen
            */

            for (int p = 0; p < Pos.Length; p++)
            {
                Pos[p].X = PosX;
                Pos[p].Y = PosY;
                switch (ausrichtung)
                {
                    case Ausrichtung.horizontal:
                        PosX++;
                        break;
                    case Ausrichtung.vertikal:
                        PosY++;
                        break;
                }
            }
            /*
             * Ausgabe des Arrays
             */
            //for (int test = 0; test < Pos.Length; test++)
            //{
            //    Console.WriteLine(Pos[test].X + " X " + Pos[test].Y + " Y ");
            //}
            foreach (SchiffCl Schiff in meineSchiffe)
            {

                if (Schiff.Name != Name)
                {
                    for (int i = 0; i < Pos.Length; i++)
                    {
                        for (int j = 0; j < Schiff.Pos.Length; j++)
                        {
                            if (Pos[i].X == Schiff.Pos[j].X && Pos[i].Y == Schiff.Pos[j].Y)
                            {
                                KannIchSoSetzen = false;
                                break;
                            }

                        }
                        if (!KannIchSoSetzen)
                            break;
                    }
                }
                                 
                if (!KannIchSoSetzen)
                    break;
            }

            //Console.WriteLine("Kann ich so setzen " + KannIchSoSetzen);

            return KannIchSoSetzen;
        }
        /// <summary>
        /// Der bool überprüft, ob alle Schiffe von einem Spieler zerstört wurden.
        /// </summary>
        /// <param name="Spieler">Als Liste. Entweder MeineSchiffe oder GegnerSchiffe</param>
        /// <returns>True, wenn alle Schiffe zerstört wurden.</returns>
        //public static bool AlleSchiffeWurdenZerstört(List<SchiffCl> Spieler)
        //{
        //    foreach (SchiffCl Schiff in Spieler)
        //    {
        //        Boolean
        //        for (int i = 0; i < Schiff.Pos.Length; i++)
        //        {
        //            if (!Schiff.Pos[i].Getroffen)
        //                return false;
        //        }
        //    }

        //    if ()


        //}
        /// <summary>
        /// Der Bool überprüft, ob ein Schiff versenkt wurde.
        /// </summary>
        /// <returns>True, wenn ein Schiff versenkt wurde.</returns>
        //private bool SchiffWurdeVersenkt()
        //{
        //    int Trefferzähler = 0;
        //    for (int i = 0; i < Pos.Length; i++)
        //    {
        //        if (Pos[i].Getroffen)
        //            Trefferzähler++;
        //    }
        //    if (Trefferzähler == Pos.Length)
        //        return true;
        //    else
        //        return false;
        //}
        /// <summary>
        /// Prüft ob Kooridinaten ein Schiff treffen
        /// </summary>
        /// <param name="PosX">Koordinate X</param>
        /// <param name="PosY">Koordinate Y</param>
        /// <returns>Enum Getroffen. Entweder wurde ein Schiff getroffe, versenkt, oder das Wasser wurde getroffen.</returns>
        public Getroffen IstTreffer(int PosX, int PosY)
        {        
            Getroffen tmpGetroffen = Getroffen.Wasser;
            for (int i = 0; i < Pos.Length; i++)
            {
                if (Pos[i].X == PosX && Pos[i].Y == PosY) // Treffer
                {
                   tmpGetroffen = Getroffen.Treffer;
                   Pos[i].Getroffen = true;
                   break;
                }
                else // Kein Treffer
                {
                    tmpGetroffen = Getroffen.Wasser;
                }
            }

            int Trefferzähler = 0;
            for (int i = 0; i < Pos.Length; i++)
            {
                if (Pos[i].Getroffen)
                    Trefferzähler++;
            }
            if (Trefferzähler == Pos.Length)
            {
                versenkt = true;
                tmpGetroffen = Getroffen.Versenkt;
            }         
            return tmpGetroffen;
        }
    }

    public class Position
    {
        public int X = 0;
        public int Y = 0;
        public Boolean Getroffen = false;
    }

    public enum Ausrichtung { horizontal, vertikal }
    public enum Getroffen { Wasser, Treffer, Versenkt }
}
