﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


namespace Schiffeversenken
{
    class Program
    {
        public static List<SchiffCl> MeineSchiffe = new List<SchiffCl>();
        public static List<SchiffCl> GegnerSchiffe = new List<SchiffCl>();
        public static Spieler SpielerAmZug = Spieler.Mensch;
        public static int MeineÜbrigenSchiffe = 5;
        public static int GegnerÜbrigenSchiffe = 5;
        //public int[,] AbgeschosseneFelder

        static void Main(string[] args)
        {

            #region Initialisierung Meiner Schiffe

            SchiffCl Uboot = new SchiffCl("Uboot", 3);
            MeineSchiffe.Add(Uboot);
            SchiffCl Uboot2 = new SchiffCl("Uboot2", 3);
            MeineSchiffe.Add(Uboot2);
            SchiffCl MinenSucher = new SchiffCl("MinenSucher", 2);
            MeineSchiffe.Add(MinenSucher);
            SchiffCl Kreutzer = new SchiffCl("Kreutzer", 4);
            MeineSchiffe.Add(Kreutzer);
            SchiffCl Flugzeugträger = new SchiffCl("Flugzeugträger", 5);
            MeineSchiffe.Add(Flugzeugträger);

            #endregion

            #region Initialisierung der Gegner Schiffe
            SchiffCl UbootGegner = new SchiffCl("UbootGegner", 3);
            GegnerSchiffe.Add(UbootGegner);
            SchiffCl UbootGegner2 = new SchiffCl("UbootGegner2", 3);
            GegnerSchiffe.Add(UbootGegner2);
            SchiffCl MinenSucherGegner = new SchiffCl("MinenSucherGegner", 2);
            GegnerSchiffe.Add(MinenSucherGegner);
            SchiffCl KreutzerGegner = new SchiffCl("KreutzerGegner", 4);
            GegnerSchiffe.Add(KreutzerGegner);
            SchiffCl FlugzeugträgerGegner = new SchiffCl("FlugzeugträgerGegner", 5);
            GegnerSchiffe.Add(FlugzeugträgerGegner);
            #endregion

            #region Setzen der eigenen Schiffe
            // Meine Schiffe
            Console.WriteLine("Setzen Sie Ihre Schiffe...");
            SetzeMeinSchiffe(MeineSchiffe);
            #endregion
            #region Setzen der Gegner Schiffe
            // Schiffe des Computers
            Console.WriteLine("Die Schiffe des Gegners werden gesetzt...");
            SetzeGegnerSchiffe(GegnerSchiffe);
            #endregion

            #region Spiel beginnt
            Console.WriteLine("Sie beginnen. Geben Sie Koordinaten ein x,y");
            do
            {
                SchiessenAufSchiff(SpielerAmZug);
            } while (MeineÜbrigenSchiffe != 0 || GegnerÜbrigenSchiffe != 0);

            Console.WriteLine("Das Spiel ist vorbei. Der " + SpielerAmZug + " hat gewonnen. Drücken Sie eine beliebige Taste zum schließen...");
            Console.ReadKey();

            #endregion
        }
        /// <summary>
        /// Die Methode setzt meine eigenen Schiffe.
        /// </summary>
        /// <param name="SchiffeZuSetzen"></param>
        public static void SetzeMeinSchiffe(List<SchiffCl> SchiffeZuSetzen)
        {
            foreach (SchiffCl Schiff in SchiffeZuSetzen)
            {
                Boolean IstEingabeKorrekt = true;
                do
                {
                    Console.WriteLine(Schiff.Name + " Länge: " + Schiff.Pos.Length + " setzen mit (x,y,h/v) << h= horizontal, v= vertikal");
                    String[] Eingabewert = Console.ReadLine().Split(',');

                    if (Eingabewert.Length == 3)
                    {
                        IstEingabeKorrekt = int.TryParse(Eingabewert[0].ToLower(), out int PosX);
                        IstEingabeKorrekt = int.TryParse(Eingabewert[1].ToLower(), out int PosY) || IstEingabeKorrekt;

                        Ausrichtung ausr;
                        if (Eingabewert[2].ToLower() == "v")
                            ausr = Ausrichtung.vertikal;
                        else
                            ausr = Ausrichtung.horizontal;
                        if (!IstEingabeKorrekt)
                            Console.WriteLine("Eingabefehler - Format beachten");

                        Boolean Positionsfehler = Schiff.SetzeSchiff(PosX, PosY, ausr, SchiffeZuSetzen);
                        if (!Positionsfehler)
                            Console.WriteLine(Schiff.Name + " Positionsfehler");
                        IstEingabeKorrekt = IstEingabeKorrekt && Positionsfehler;                  
                    }
                    else
                    {
                        Console.WriteLine("Es wurden nicht alle Koordinaten angegeben. Bitte beachten Sie das Muster.");
                        IstEingabeKorrekt = false;
                    }
                    Console.WriteLine();
                } while (!IstEingabeKorrekt);
                
            }

            foreach (SchiffCl Schiff in MeineSchiffe)
            {
                Console.WriteLine(Schiff.Name);
                for (int i = 0; i < Schiff.Pos.Length; i++)
                {
                    Console.WriteLine("X=" + Schiff.Pos[i].X + " Y=" + Schiff.Pos[i].Y);
                }
                Console.WriteLine("-------");
            }

        }
        /// <summary>
        /// Die Methode setzt die Schiffe des Gegners zufällig.
        /// </summary>
        /// <param name="SchiffeZuSetzen">Wen gehören die Schiffe? (MeineSchiffe || GegnerSchiffe)</param>
        public static void SetzeGegnerSchiffe(List<SchiffCl> SchiffeZuSetzen)
        {
            foreach (SchiffCl Schiff in SchiffeZuSetzen)
            {
                Boolean IstEingabeKorrekt = false;
                do
                {
                    Random rnd = new Random();
                    Ausrichtung ausr;

                    int ZufallsX = 0;
                    int ZufallsY = 0;
                    int ZufallAusrichtung = rnd.Next(2);

                    if (ZufallAusrichtung == 0) // horizontal
                    {                        
                        ZufallsX = rnd.Next(SchiffCl.MaxXY - Schiff.Pos.Length); //Sofern horizontal!
                        ZufallsY = rnd.Next(SchiffCl.MaxXY); //Sofern horizontal!
                        ausr = Ausrichtung.horizontal;                                        
                    }
                    else
                    {
                        ZufallsX = rnd.Next(SchiffCl.MaxXY); //Sofern vertikal!
                        ZufallsY = rnd.Next(SchiffCl.MaxXY - Schiff.Pos.Length); //Sofern vertikal! 
                        ausr = Ausrichtung.vertikal;
                    }

                    Console.WriteLine("Versuche " + Schiff.Name + " zu setzen." + Environment.NewLine + "Koordinaten:" + Environment.NewLine + "X=" + ZufallsX + Environment.NewLine + "Y=" + ZufallsY + Environment.NewLine + "Länge: " + Schiff.Pos.Length + Environment.NewLine + "Ausrichtung:" + ausr);

                    Boolean Positionsfehler = Schiff.SetzeSchiff(ZufallsX, ZufallsY, ausr, SchiffeZuSetzen);
                    if (!Positionsfehler)
                        Console.WriteLine("Das Schiff konnte nicht zufällig gesetzt werden. Es wird erneut versucht.");
                    IstEingabeKorrekt = Positionsfehler;
                    
                    //Console.WriteLine(IstEingabeKorrekt);
                    //Console.ReadKey();

                } while (!IstEingabeKorrekt);

            }

            Console.WriteLine("Alle Schiffe des Computers wurden gesetzt!" + Environment.NewLine + "Das Spiel beginnt...");
            foreach (SchiffCl Schiff in GegnerSchiffe)
            {
                Console.WriteLine(Schiff.Name);
                for (int i = 0; i < Schiff.Pos.Length; i++)
                {
                    Console.WriteLine("X=" + Schiff.Pos[i].X +  " Y=" + Schiff.Pos[i].Y);
                }
                Console.WriteLine("-------");
            }

        }
        /// <summary>
        /// Die Methode wechselt den aktuellen Spieler, der am Zug ist.
        /// </summary>
        private static void WechsleSpieler(Boolean SpielerIstErneutAmZug)
        {
            if(!SpielerIstErneutAmZug && SpielerAmZug == Spieler.Computer)            
                SpielerAmZug = Spieler.Mensch;
            else if(!SpielerIstErneutAmZug && SpielerAmZug == Spieler.Mensch)
                SpielerAmZug = Spieler.Computer;

            Console.WriteLine(SpielerAmZug + " ist am Zug");
        }

        public static void SchiessenAufSchiff(Spieler spielerAmZug)
        {
            Boolean eingabeFehler = false;
            do
            {
                int PosX = 0;
                int PosY = 0;
                List<SchiffCl> BeschossenerSpieler = GegnerSchiffe;

                switch (spielerAmZug)
                {
                    case Spieler.Mensch:
                        String[] SchussEingabe = Console.ReadLine().Split(',');
                        if (SchussEingabe.Length == 2)
                        {
                            eingabeFehler = !Int32.TryParse(SchussEingabe[0].ToLower(), out PosX);
                            eingabeFehler = !Int32.TryParse(SchussEingabe[1].ToLower(), out PosY) || eingabeFehler;
                            if (PosX > SchiffCl.MaxXY || PosY > SchiffCl.MaxXY)
                                eingabeFehler = true;

                            if (!eingabeFehler)
                            {
                                BeschossenerSpieler = GegnerSchiffe;
                                break;
                            }
                            else
                            {
                                Console.WriteLine("Es wurden keine Zahlen eingegeben. Bitte beachten Sie das Format.");
                            }
                        }
                        else
                        {
                            Console.WriteLine("Die Eingabe entspricht nicht dem Format x,y");
                            eingabeFehler = true;
                        }
                        break;
                    case Spieler.Computer:
                        Random rdm = new Random();
                        PosX = rdm.Next(SchiffCl.MaxXY);
                        PosY = rdm.Next(SchiffCl.MaxXY);
                        BeschossenerSpieler = MeineSchiffe;
                        break;
                }
                if (!eingabeFehler)
                {
                    Boolean SpielerIstErneutDran = false;
                    
                    foreach (SchiffCl Schiff in BeschossenerSpieler)
                    {
                        Getroffen IstTreffer = Schiff.IstTreffer(PosX, PosY);

                        if (IstTreffer == Getroffen.Treffer)
                        {
                            Console.WriteLine("Sie haben die Koordinaten X = " + PosX + " Y = " + PosY + " beschossen.Sie haben das Schiff " + Schiff.Name + " getroffen.");
                            SpielerIstErneutDran = true;
                            break;
                        }
                        else if (IstTreffer == Getroffen.Versenkt)
                        {
                            Console.WriteLine("Sie haben die Koordinaten X=" + PosX + " Y=" + PosY + " beschossen. Sie haben das Schiff " + Schiff.Name + " versenkt");
                            GegnerÜbrigenSchiffe--;
                            SpielerIstErneutDran = true;
                            break;
                        }
                        
                    }
                    if(!SpielerIstErneutDran)
                        Console.WriteLine("Sie haben die Koordinaten X=" + PosX + " Y=" + PosY + " beschossen. Sie trafen Wasser.");

                    WechsleSpieler(SpielerIstErneutDran);
                }
                
            }
            while (eingabeFehler); 
        }

        public enum Spieler { Mensch, Computer }

    }

}
