﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace CheckNumber
{
    public partial class CalcForm : Form
    {
        public CalcForm()
        {
            InitializeComponent();
        }

        private void btnCheckNumber_Click(object sender, EventArgs e)
        {
            if (tbEingabe.Text.Length == 0)
            {
                MessageBox.Show("Bitte geben Sie eine Zahl ein", "Fehler", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                int eingabe = Convert.ToInt32(tbEingabe.Text);

                if (eingabe > 3200000)
                {
                    MessageBox.Show("Die eingegebene Zahl ist zu groß. Bitte geben Sie eine kleinere Zahl ein.", "Fehler", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else if (eingabe <= 0)
                {
                    MessageBox.Show("Die eingegebene Zahl darf nicht kleiner, oder gleich 0 sein. Bitte geben Sie eine größere Zahl an.", "Fehler", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                {
                    if (tbEingabe.Text.SequenceEqual(tbEingabe.Text.Reverse()))
                    {
                        MessageBox.Show("Eingabe ist ein Palindrom.", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }
                    else
                    {
                        MessageBox.Show("Eingabe ist kein Palindrom.", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    }

                }
            }
        }
        //Sperre alle Eingaben außer Zahlen
        private void tbEingabe_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (char.IsDigit(e.KeyChar) || char.IsControl(e.KeyChar))
                e.Handled = false;
            else
                e.Handled = true;
        }

        private void btnSchleife_Click(object sender, EventArgs e)
        {
            if (tbEingabe.Text.Length == 0)
            {
                MessageBox.Show("Bitte geben Sie eine Zahl ein.", "Fehler", MessageBoxButtons.OK,MessageBoxIcon.Error);
            }
            else
            {
                int eingabe = Convert.ToInt32(tbEingabe.Text);
                if (eingabe > 3200000)
                {
                    MessageBox.Show("Die eingegebene Zahl ist zu groß. Bitte geben Sie eine kleinere Zahl ein.", "Fehler", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else if (eingabe <= 0)
                {
                    MessageBox.Show("Die eingegebene Zahl darf nicht kleiner, oder gleich 0 sein. Bitte geben Sie eine größere Zahl an.", "Fehler", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                {

                    int eingabeLength = tbEingabe.Text.Length - 1; // -1 um Index.OutOfRange zu vermeiden // Rechte seite der Eingabe
                    int eingabeLengthHalf = tbEingabe.Text.Length / 2; //Durch zwei teilen, damit jeweils die Hälfte jeder Seite überprüft wird. // Linke Seite der Eingabe


                    for (int i = 0; i <= eingabeLengthHalf; i++)
                    {
                        if (tbEingabe.Text[i] != tbEingabe.Text[eingabeLength]) // i = Zeichen im String, beginn bei 0. eingabeLength ist das rechte Zeichen.
                        {
                            MessageBox.Show("Eingabe ist kein Palindrom.", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            break;
                        }
                        else
                        {
                            if (i == eingabeLengthHalf)
                            {
                                MessageBox.Show("Eingabe ist ein Palindrom.", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information);
                            }
                        }

                        eingabeLength--; // Reduzierung um 1, um die rechte Seite der Eingabe zu überprüfen.
                    }
                }
            }

        }
    }
}
