using FluentValidation;
using Messeportal.Core.Services;
using Microsoft.AspNetCore.Authentication.Cookies;
using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using Serilog;
using System.Reflection;
using System.Security.Claims;

var builder = WebApplication.CreateBuilder(args);

// Add services to the container.
builder.Services.AddRazorPages();
builder.Services.AddServerSideBlazor()
                    .AddCircuitOptions(options => { options.DetailedErrors = true; });

builder.Services.AddAuthentication(CookieAuthenticationDefaults.AuthenticationScheme)
                .AddCookie(CookieAuthenticationDefaults.AuthenticationScheme, configureOptions =>
                {
                });

builder.Services.AddAuthorization(options =>
{

});



// FluentValidation
builder.Services.AddValidatorsFromAssembly(Assembly.LoadFrom(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Messeportal.Core.dll")));

builder.Configuration.AddJsonFile(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "appsettings.json"), false, true);
await AppdatenService.InitAsync(builder.Configuration);

MitarbeiterService.ActiveDirectoryUserExists = false; // TODO: Abfragen und setzen
// TODO: Serilog einbinden
/*Log.Logger = new LoggerConfiguration()
                .ReadFrom.Configuration(builder.Configuration)
                .CreateLogger();*/


builder.Services.AddScoped<MitarbeiterService>();
builder.Services.AddScoped<BerechtigungService>();
builder.Services.AddScoped<UserService>();

var app = builder.Build();

// Configure the HTTP request pipeline.
if (!app.Environment.IsDevelopment())
{
    app.UseExceptionHandler("/Error");
    // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
    app.UseHsts();
}

app.UseHttpsRedirection();

app.UseStaticFiles();

app.UseRouting();
app.UseAuthentication();
app.UseMiddleware<ClaimsMiddleWare>();
app.MapBlazorHub();
app.MapFallbackToPage("/_Host");

app.Run();

public partial class Program
{
    public static string GetVersion()
    {
        return Assembly.GetEntryAssembly()!.GetName()!.Version!.ToString(3);
    }
}


public class ClaimsMiddleWare
{
    private readonly RequestDelegate _next;

    public ClaimsMiddleWare(RequestDelegate next)
    {
        _next = next;
    }

    public async Task InvokeAsync(HttpContext httpContext)
    {
        // Eventuell fr die Prfung auf neue Claims interessant
        Console.WriteLine($"{nameof(ClaimsMiddleWare)} called");
        //if (httpContext.User != null && httpContext.User.Identity.IsAuthenticated)
        //{

        //    //httpContext.User.Identities.FirstOrDefault().AddClaim(new Claim("your claim", "your field"));
        //}
        await _next(httpContext);
    }
}