using Messeportal.Core.Models;
using Messeportal.Core.Filters;
using Microsoft.AspNetCore.Components.Forms;
using Microsoft.AspNetCore.Components;
using ScholzLibrary.Basis.Erweiterungen;
using Messeportal.Core.Services;
using ScholzLibrary;
using Blazor.Pagination;
using Microsoft.AspNetCore.Identity;

namespace Messeportal.Pages.Admin
{
    public partial class Benutzerverwaltung : IHasPagination
    {
        public BenutzerFilter Filter { get; set; } = new BenutzerFilter();

        public Mitarbeiter? Input { get; set; }
        public Mitarbeiter? SelectedForDeletion { get; set; }
        public Berechtigung? SelectedBerechtigung { get; set; }
        public int Page { get => _page; set => _page = value < 1 ? 1 : value; }
        public int TotalItems { get; set; }

        private EditForm? _form;
        private int _page = 1;
        private List<Mitarbeiter> _mitarbeiter = new List<Mitarbeiter>();
        private Mitarbeiter? _loggedInUser;
        protected override async Task OnParametersSetAsync()
        {
            _loggedInUser = await userService.GetUserAsync();
            await LoadAsync();
        }

        private async Task SaveAsync()
        {
            if (Input is null || _form is null || _form.EditContext is null)
            {
                return;
            }

            if (_form.EditContext.Validate())
            {

                using SqlController sqlController = new SqlController(AppdatenService.ConnectionString);

                if (Input.UserId is 0)
                {
                    PasswordHasher<Mitarbeiter> hasher = new PasswordHasher<Mitarbeiter>();
                    string passwordHashed = hasher.HashPassword(Input, Input.Passwort + Input.Salt);
                    Input.Passwort = passwordHashed;
                    await mitarbeiterService.CreateAsync(Input, sqlController);
                }
                else
                {
                    await mitarbeiterService.UpdateAsync(Input, sqlController);
                }


                await jsRuntime.ShowToastAsync(ToastType.success, "Datensatz erfolgreich gespeichert");
                await LoadAsync();
                Input = null;
            }
        }
        public async Task LoadAsync(bool navigateToPage1 = false)
        {
            Filter.Seite = navigateToPage1 ? 1 : Page;
            using SqlController sqlController = new SqlController(AppdatenService.ConnectionString);
            TotalItems = await mitarbeiterService.GetTotalAsync(Filter, sqlController);
            _mitarbeiter = await mitarbeiterService.GetAsync(Filter, sqlController);
        }

        private async Task DeleteAsync()
        {
            if (SelectedForDeletion is null)
            {
                return;
            }

            using SqlController sqlController = new SqlController(AppdatenService.ConnectionString);
            await mitarbeiterService.DeleteAsync(SelectedForDeletion, sqlController);
            await jsRuntime.ShowToastAsync(ToastType.success, "Benutzer wurde erfolgreich gelscht");

        }
        private Task NewAsync()
        {
            Input = new Mitarbeiter
            {
                Herkunft = "lokal",
                Salt = StringErweiterungen.RandomString(10)
            };

            return Task.CompletedTask;
        }
        private Task EditAsync(Mitarbeiter input)
        {
            Input = input.DeepCopy();
            return Task.CompletedTask;
        }

        private Task AddBerechtigungAsync()
        {
            if (Input is not null)
            {
                if (SelectedBerechtigung is not null)
                {
                    Input.Berechtigungen.Add(SelectedBerechtigung);
                }

                SelectedBerechtigung = null;
            }

            return Task.CompletedTask;
        }
        private Task BerechtigungSelectionChangedAsync(ChangeEventArgs e)
        {
            int berechtigungId = Convert.ToInt32(e.Value);
            SelectedBerechtigung = AppdatenService.Berechtigungen.FirstOrDefault(x => x.BerechtigungId == berechtigungId);
            return Task.CompletedTask;
        }


    }
}