﻿using FluentValidation;
using Messeportal.Core.Models;
using ScholzLibrary.Basis.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Messeportal.Core.Validators.Admin
{
    public class MitarbeiterValidator : AbstractValidator<Mitarbeiter>
    {
        public MitarbeiterValidator()
        {
            RuleFor(x => x.Username)
                .NotEmpty()
                .MaximumLength(50);

            RuleFor(x => x.Anzeigename)
                .NotEmpty()
                .MaximumLength(100);


            RuleFor(x => x.Email)
                .NotEmpty()
                .MaximumLength(255)
                .Must(StringErweiterungen.IstEmail)
                .WithMessage("Bitte geben Sie eine gültige E-Mail an");
        }

    }
}
