﻿using Messeportal.Core.Models;
using Microsoft.AspNetCore.Components.Authorization;
using Microsoft.AspNetCore.Http;
using ScholzLibrary;
using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Security.Claims;
using System.Text;
using System.Threading.Tasks;

namespace Messeportal.Core.Services
{
    /// <summary>
    /// Service für die Abfrage des Users auf Basis des HttpContext von ASP.NET
    /// </summary>
    public class UserService
    {
        private readonly AuthenticationStateProvider _authenticationStateProvider;
        private readonly MitarbeiterService _mitarbeiterService;

        public UserService(AuthenticationStateProvider authenticationStateProvider, MitarbeiterService mitarbeiterService)
        {
            _authenticationStateProvider = authenticationStateProvider;
            _mitarbeiterService = mitarbeiterService;
        }

        public async Task<Mitarbeiter?> GetUserAsync()
        {

            var authState = await _authenticationStateProvider.GetAuthenticationStateAsync();
            var user = authState.User;
            if (user.Identity is not null && user.Identity.IsAuthenticated)
            {
                Claim? claim = user.FindFirst("userId");
                if (claim is null)
                {
                    return null;
                }

                var userId = Convert.ToInt32(claim.Value);

                SqlController sqlController = new SqlController(AppdatenService.ConnectionString);
                return await _mitarbeiterService.GetAsync(userId, sqlController);
            }

            return null;
        }
    }
}
