﻿using ScholzLibrary;

namespace Messeportal.Core.Services
{
    /// <summary>
    /// Standartisiert die CRUD-Operations von Model-Services 
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public interface IModelService<T>
    {
        /// <summary>
        /// Speichert das Objekt in der Datenbank als neuen Datensatz.
        /// </summary>
        /// <param name="input"></param>
        /// <param name="fbController"></param>
        /// <returns></returns>
        Task CreateAsync(T input, SqlController sqlController);
        /// <summary>
        /// Aktualisiert den Datensatz für das Objekt in der Datenbank
        /// </summary>
        /// <param name="input"></param>
        /// <param name="fbController"></param>
        /// <returns></returns>
        Task UpdateAsync(T input, SqlController sqlController);
    }
    /// <summary>
    /// <inheritdoc/>
    /// <para>
    /// Erweitert die Standard CRUD Operations noch um das Laden eines einzelnen Objektes.
    /// </para>
    /// </summary>
    /// <typeparam name="T"></typeparam>
    /// <typeparam name="GetKeyIdentifier"></typeparam>
    public interface IModelService<T, TIdentifier> : IModelService<T>
    {
        /// <summary>
        /// Lädt ein Objekt aus der Datenbank für einen besteimmten Identifier
        /// </summary>
        /// <param name="identifier">Identifier, wie das Objekt in der Datenbank identifiziert werden kann.</param>
        /// <param name="fbController"></param>
        /// <returns>
        /// Wenn das Objekt in der Datenbank für den Identifier existiert, dann wird dieses zurückgeben. Ansonsten wird null zurückgegeben.
        /// </returns>
        Task<T?> GetAsync(TIdentifier identifier, SqlController sqlController);
    }

    public interface IModelService<T, TIdentifier, TFilter> : IModelService<T, TIdentifier>
    {
        Task<List<T>> GetAsync(TFilter filter, SqlController sqlController);
        Task<int> GetTotalAsync(TFilter filter, SqlController sqlController);
        string GetFilterWhere(TFilter filter);
        object? GetFilterParameter(TFilter filter);
    }
}
