﻿using Messeportal.Core.Models;
using Microsoft.Extensions.Configuration;
using ScholzLibrary;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Messeportal.Core.Services
{
    public static class AppdatenService
    {
        private static IConfiguration? _configuration;
        public static List<Berechtigung> Berechtigungen { get; private set; } = new();
        public static List<Land> Länder { get; private set; } = new();


        public static async Task InitAsync(IConfiguration configuration)
        {
            _configuration = configuration;

            using SqlController sqlController = new SqlController(ConnectionString);

            Berechtigungen = await BerechtigungService.GetAllAsync(sqlController);
            Länder = await LandService.GetAllAsnyc(sqlController);

        }

        public static string ConnectionString => _configuration?.GetConnectionString("Default") ?? string.Empty;
        public static string LdapServer => _configuration?["Login:LDAP_SERVER"] ?? string.Empty;
        public static string LdapDomainServer => _configuration?["Login:DOMAIN_SERVER"] ?? string.Empty;
        public static string LdapDistinguishedName => _configuration?["Login:DistinguishedName"] ?? string.Empty;

    }
}
