CREATE TABLE [berechtigungen] (
	berechtigung_id integer IDENTITY(1,1) NOT NULL,
	berechtigung_name varchar(50) NOT NULL,
	berechtigung_identifier varchar(50) NOT NULL UNIQUE,
	berechtigung_beschreibung text NOT NULL,
	PRIMARY KEY (berechtigung_id)
);


CREATE TABLE [users] (
	user_id integer IDENTITY(1,1) NOT NULL,
	username varchar(50) NOT NULL,
	anzeigename varchar(100) NOT NULL,
	active_directory_guid varchar(36),
	email varchar(255) NOT NULL,
    passwort VARCHAR(255) NOT NULL DEFAULT '',
    salt VARCHAR(255) NOT NULL DEFAULT '',
    herkunft VARCHAR(5) NOT NULL DEFAULT '',
	PRIMARY KEY(user_id)
);

CREATE TABLE [user_berechtigungen] (
	user_id integer NOT NULL,
	berechtigung_id integer NOT NULL,
	PRIMARY KEY(user_id, berechtigung_id),
    FOREIGN KEY ([user_id]) REFERENCES [users]([user_id]),
    FOREIGN KEY ([berechtigung_id]) REFERENCES [berechtigungen]([berechtigung_id]),
);

CREATE TABLE [messen] (
    messe_id integer IDENTITY(1,1) NOT NULL,
    [name] VARCHAR(50) NOT NULL,
    start_datum date NOT NULL,
    ende_datum date NOT NULL,
    date_added datetime NOT NULL,
    date_modified DATETIME not null,
    PRIMARY KEY(messe_id)
);

CREATE TABLE [messe_to_user] (
    messe_id INTEGER NOT NULL,
    user_id INTEGER NOT NULL,
    PRIMARY KEY (messe_id, user_id),
    FOREIGN KEY ([user_id]) REFERENCES [users]([user_id]),
    FOREIGN KEY ([messe_id]) REFERENCES [messen]([messe_id]),
);

CREATE TABLE [aktionen] (
    aktion_id INTEGER IDENTITY(1,1) NOT NULL,
    [name] VARCHAR(50) NOT NULL,
    beschreibung text NOT NULL,
    date_added DATETIME NOT NULL,
    date_modified DATETIME not null,
    PRIMARY KEY(aktion_id)
);

CREATE TABLE [empfaenger] (
    empfaenger_id INTEGER IDENTITY(1,1) NOT NULL,
    [name] VARCHAR(50) NOT NULL,
    PRIMARY KEY(empfaenger_id)
);

CREATE TABLE [empfaenger_to_aktion] (
    empfaenger_id INTEGER NOT NULL,
    aktion_id INTEGER NOT NULL,
    PRIMARY KEY(empfaenger_id, aktion_id),
    FOREIGN KEY ([empfaenger_id]) REFERENCES [empfaenger]([empfaenger_id]),
    FOREIGN KEY ([aktion_id]) REFERENCES [aktionen]([aktion_id]),
);

CREATE TABLE [empfaenger_mails] (
    empfaenger_mail_id INTEGER IDENTITY(1,1) NOT NULL,
    empfaenger_id INTEGER NOT NULL,
    email VARCHAR(255) NOT NULL,
    PRIMARY KEY (empfaenger_mail_id),
    FOREIGN KEY ([empfaenger_id]) REFERENCES [empfaenger]([empfaenger_id])
);

CREATE TABLE [countries] (
    country_id INTEGER IDENTITY(1,1) NOT NULL,
    [name] varchar(128) NOT NULL,
    iso_code_2 VARCHAR(2) NOT NULL,
    iso_code_3 VARCHAR(3) NOT NULL,
    [status] TINYINT NOT NULL DEFAULT 0,
    PRIMARY KEY(country_id)
);

CREATE TABLE [custom_fields] (
    custom_field_id INTEGER IDENTITY(1,1) NOT NULL,
    [type] VARCHAR(32) NOT NULL,
    [name] VARCHAR(128) NOT NULL,
    is_required TINYINT not null DEFAULT 0,
    is_active TINYINT not null DEFAULT 0,
    sort_order INTEGER not null DEFAULT 0,
    PRIMARY KEY(custom_field_id)
);

CREATE TABLE [custom_fields_value] (
    value_id INTEGER IDENTITY(1,1) NOT NULL,
    custom_field_id INTEGER not null,
    [name] VARCHAR(128),
    sort_order INTEGER not null default 0,
    PRIMARY KEY(value_id),
    FOREIGN KEY ([custom_field_id]) REFERENCES [custom_fields]([custom_field_id])
);

CREATE TABLE [notizen] (
    notiz_id INTEGER IDENTITY(1,1) not null,
    messe_id INTEGER NOT NULL,
    user_id INTEGER NOT NULL,
    kundennummer VARCHAR(255) not null default '',
    datum date not null,
    branche VARCHAR(255) not null,
    firma VARCHAR(255) not null,
    strasse VARCHAR(255) not null,
    postleitzahl VARCHAR(8) not null,
    ort VARCHAR(255) not null,
    country_id INTEGER not nulL,
    telefon VARCHAR(255) not null,
    email VARCHAR(255) not null,
    PRIMARY KEY(notiz_id),
    FOREIGN KEY ([messe_id]) REFERENCES [messen]([messe_id]),
    FOREIGN KEY ([user_id]) REFERENCES [users]([user_id]),
    FOREIGN KEY ([country_id]) REFERENCES [countries]([country_id])
);

CREATE TABLE [notizen_besucher](
    besucher_id INTEGER IDENTITY(1,1) NOT NULL,
    notiz_id INTEGER NOT NULL,
    [name] VARCHAR(255) NOT NULL,
    PRIMARY KEY(besucher_id),
    FOREIGN KEY ([notiz_id]) REFERENCES [notizen]([notiz_id])
);

CREATE TABLE [notizen_custom_fields](
    notiz_id INTEGER NOT NULL,
    custom_field_id INTEGER NOT NULL,
    [name] VARCHAR(255) NOT NULL,
    [value] text NOT NULL,
    [type] VARCHAR(32) NOT NULL
    PRIMARY KEY(notiz_id, custom_field_id),
    FOREIGN KEY ([notiz_id]) REFERENCES [notizen]([notiz_id]),
    FOREIGN KEY ([custom_field_id]) REFERENCES [custom_fields]([custom_field_id]),
);

CREATE TABLE [notizen_assignment] (
    assignment_id INTEGER IDENTITY(1,1) NOT NULL,
    notiz_id INTEGER NOT NULL,
    user_id INTEGER NOT NULL,
    [name] VARCHAR(50) NOT NULL,
    PRIMARY KEY(assignment_id),
    FOREIGN KEY ([notiz_id]) REFERENCES [notizen]([notiz_id]),
    FOREIGN KEY ([user_id]) REFERENCES [users]([user_id])
);

CREATE TABLE [notizen_attachments] (
    attachment_id INTEGER IDENTITY(1,1) NOT NULL,
    notiz_id INTEGER NOT NULL,
    attachment_data varbinary(MAX) NOT NULL,
    PRIMARY KEY (attachment_id),
    FOREIGN KEY ([notiz_id]) REFERENCES [notizen]([notiz_id])
);

CREATE TABLE [notizen_aktionen] (
    notiz_aktion_id INTEGER IDENTITY(1,1),
    notiz_id INTEGER NOT NULL,
    aktion_id INTEGER NOT NULL,
    empfaenger_id INTEGER NOT NULL,
    anlage_user_id INTEGER NOT NULL,
    anweisung TEXT NOT NULL DEFAULT '',
    [status] TINYINT NOT NULL DEFAULT 0,
    PRIMARY KEY(notiz_aktion_id),
    FOREIGN KEY ([notiz_id]) REFERENCES [notizen]([notiz_id]),
    FOREIGN KEY ([aktion_id]) REFERENCES [aktionen]([aktion_id]),
    FOREIGN KEY ([anlage_user_id]) REFERENCES [users]([user_id])
);



/* Daten */

INSERT INTO [countries] ([name], [iso_code_2], [iso_code_3], [status]) VALUES
('Afghanistan', 'AF', 'AFG', 1),
('Albanien', 'AL', 'ALB', 1),
('Algerien', 'DZ', 'DZA', 1),
('American Samoa', 'AS', 'ASM', 1),
('Andorra', 'AD', 'AND', 1),
('Angola', 'AO', 'AGO', 1),
('Anguilla', 'AI', 'AIA', 1),
('Antarctica', 'AQ', 'ATA', 1),
('Antigua and Barbuda', 'AG', 'ATG', 1),
('Argentinien', 'AR', 'ARG', 1),
('Armenien', 'AM', 'ARM', 1),
('Aruba', 'AW', 'ABW', 1),
('Australien', 'AU', 'AUS', 1),
('Österreich', 'AT', 'AUT', 1),
('Azerbaijan', 'AZ', 'AZE', 1),
('Bahamas', 'BS', 'BHS', 1),
('Bahrain', 'BH', 'BHR', 1),
('Bangladesh', 'BD', 'BGD', 1),
('Barbados', 'BB', 'BRB', 1),
('Belarus', 'BY', 'BLR', 1),
('Belgien', 'BE', 'BEL', 1),
('Belize', 'BZ', 'BLZ', 1),
('Benin', 'BJ', 'BEN', 1),
('Bermuda', 'BM', 'BMU', 1),
('Bhutan', 'BT', 'BTN', 1),
('Boliviem', 'BO', 'BOL', 1),
('Bosnia and Herzegovina', 'BA', 'BIH', 1),
('Botswana', 'BW', 'BWA', 1),
('Bouvet Island', 'BV', 'BVT', 1),
('Brazilien', 'BR', 'BRA', 1),
('British Indian Ocean Territory', 'IO', 'IOT', 1),
('Brunei Darussalam', 'BN', 'BRN', 1),
('Bulgarien', 'BG', 'BGR', 1),
('Burkina Faso', 'BF', 'BFA', 1),
('Burundi', 'BI', 'BDI', 1),
('Cambodia', 'KH', 'KHM', 1),
('Cameroon', 'CM', 'CMR', 1),
('Canada', 'CA', 'CAN', 1),
('Cape Verde', 'CV', 'CPV', 1),
('Cayman Islands', 'KY', 'CYM', 1),
('Central African Republic', 'CF', 'CAF', 1),
('Chad', 'TD', 'TCD', 1),
('Chile', 'CL', 'CHL', 1),
('China', 'CN', 'CHN', 1),
('Christmas Island', 'CX', 'CXR', 1),
('Cocos (Keeling) Islands', 'CC', 'CCK', 1),
('Kolombien', 'CO', 'COL', 1),
('Comoros', 'KM', 'COM', 1),
('Congo', 'CG', 'COG', 1),
('Cook Islands', 'CK', 'COK', 1),
('Costa Rica', 'CR', 'CRI', 1),
('Cote DIvoire', 'CI', 'CIV', 1),
('Kroatien', 'HR', 'HRV', 1),
('Cuba', 'CU', 'CUB', 1),
('Cyprus', 'CY', 'CYP', 1),
('Czech Republic', 'CZ', 'CZE', 1),
('Dänemark', 'DK', 'DNK', 1),
('Djibouti', 'DJ', 'DJI', 1),
('Dominica', 'DM', 'DMA', 1),
('Dominican Republic', 'DO', 'DOM', 1),
('East Timor', 'TL', 'TLS', 1),
('Ecuador', 'EC', 'ECU', 1),
('Ägypten', 'EG', 'EGY', 1),
('El Salvador', 'SV', 'SLV', 1),
('Equatorial Guinea', 'GQ', 'GNQ', 1),
('Eritrea', 'ER', 'ERI', 1),
('Estland', 'EE', 'EST', 1),
('Ethiopia', 'ET', 'ETH', 1),
('Falkland Islands (Malvinas)', 'FK', 'FLK', 1),
('Faroe Islands', 'FO', 'FRO', 1),
('Fiji', 'FJ', 'FJI', 1),
('Finnland', 'FI', 'FIN', 1),
('Frankreich', 'FR', 'FRA', 1),
('Gabon', 'GA', 'GAB', 1),
('Gambia', 'GM', 'GMB', 1),
('Georgien', 'GE', 'GEO', 1),
('Deutschland', 'DE', 'DEU', 1),
('Ghana', 'GH', 'GHA', 1),
('Gibraltar', 'GI', 'GIB', 1),
('Griechenland', 'GR', 'GRC', 1),
('Grönland', 'GL', 'GRL', 1),
('Grenada', 'GD', 'GRD', 1),
('Guadeloupe', 'GP', 'GLP', 1),
('Guam', 'GU', 'GUM', 1),
('Guatemala', 'GT', 'GTM', 1),
('Guinea', 'GN', 'GIN', 1),
('Guinea-Bissau', 'GW', 'GNB', 1),
('Guyana', 'GY', 'GUY', 1),
('Haiti', 'HT', 'HTI', 1),
('Honduras', 'HN', 'HND', 1),
('Hong Kong', 'HK', 'HKG', 1),
('Hungary', 'HU', 'HUN', 1),
('Island', 'IS', 'ISL', 1),
('Indien', 'IN', 'IND', 1),
('Indonesien', 'ID', 'IDN', 1),
('Iran', 'IR', 'IRN', 1),
('Irak', 'IQ', 'IRQ', 1),
('Ireland', 'IE', 'IRL', 1),
('Israel', 'IL', 'ISR', 1),
('Italien', 'IT', 'ITA', 1),
('Jamaica', 'JM', 'JAM', 1),
('Japan', 'JP', 'JPN', 1),
('Jordan', 'JO', 'JOR', 1),
('Kazakhstan', 'KZ', 'KAZ', 1),
('Kenya', 'KE', 'KEN', 1),
('Nordkorea', 'KP', 'PRK', 1),
('Südkorea', 'KR', 'KOR', 1),
('Kuwait', 'KW', 'KWT', 1),
('Kyrgyzstan', 'KG', 'KGZ', 1),
('Litauen', 'LV', 'LVA', 1),
('Lebanon', 'LB', 'LBN', 1),
('Liberia', 'LR', 'LBR', 1),
('Liechtenstein', 'LI', 'LIE', 1),
('Lithuania', 'LT', 'LTU', 1),
('Luxemburg', 'LU', 'LUX', 1),
('Madagascar', 'MG', 'MDG', 1),
('Malawi', 'MW', 'MWI', 1),
('Malaysia', 'MY', 'MYS', 1),
('Mali', 'ML', 'MLI', 1),
('Malta', 'MT', 'MLT', 1),
('Martinique', 'MQ', 'MTQ', 1),
('Mauritania', 'MR', 'MRT', 1),
('Mauritius', 'MU', 'MUS', 1),
('Mayotte', 'YT', 'MYT', 1),
('Mexico', 'MX', 'MEX', 1),
('Monaco', 'MC', 'MCO', 1),
('Mongolia', 'MN', 'MNG', 1),
('Montserrat', 'MS', 'MSR', 1),
('Morocco', 'MA', 'MAR', 1),
('Mozambique', 'MZ', 'MOZ', 1),
('Myanmar', 'MM', 'MMR', 1),
('Namibia', 'NA', 'NAM', 1),
('Nauru', 'NR', 'NRU', 1),
('Nepal', 'NP', 'NPL', 1),
('Netherlands', 'NL', 'NLD', 1),
('Netherlands Antilles', 'AN', 'ANT', 1),
('New Caledonia', 'NC', 'NCL', 1),
('Neu Seeland', 'NZ', 'NZL', 1),
('Nicaragua', 'NI', 'NIC', 1),
('Niger', 'NE', 'NER', 1),
('Nigeria', 'NG', 'NGA', 1),
('Niue', 'NU', 'NIU', 1),
('Norway', 'NO', 'NOR', 1),
('Oman', 'OM', 'OMN', 1),
('Pakistan', 'PK', 'PAK', 1),
('Palau', 'PW', 'PLW', 1),
('Panama', 'PA', 'PAN', 1),
('Paraguay', 'PY', 'PRY', 1),
('Peru', 'PE', 'PER', 1),
('Philippines', 'PH', 'PHL', 1),
('Polen', 'PL', 'POL', 1),
('Portugal', 'PT', 'PRT', 1),
('Puerto Rico', 'PR', 'PRI', 1),
('Katar', 'QA', 'QAT', 1),
('Reunion', 'RE', 'REU', 1),
('Rumänian', 'RO', 'ROM', 1),
('Russland', 'RU', 'RUS', 1),
('Samoa', 'WS', 'WSM', 1),
('San Marino', 'SM', 'SMR', 1),
('Saudi Arabien', 'SA', 'SAU', 1),
('Senegal', 'SN', 'SEN', 1),
('Seychelles', 'SC', 'SYC', 1),
('Sierra Leone', 'SL', 'SLE', 1),
('Singapore', 'SG', 'SGP', 1),
('Slovak Republic', 'SK', 'SVK', 1),
('Slovenia', 'SI', 'SVN', 1),
('Solomon Islands', 'SB', 'SLB', 1),
('Somalien', 'SO', 'SOM', 1),
('Süd Afrika', 'ZA', 'ZAF', 1),
('South Georgia &amp; South Sandwich Islands', 'GS', 'SGS', 1),
('Spanien', 'ES', 'ESP', 1),
('Sri Lanka', 'LK', 'LKA', 1),
('Sudan', 'SD', 'SDN', 1),
('Suriname', 'SR', 'SUR', 1),
('Swaziland', 'SZ', 'SWZ', 1),
('Sweden', 'SE', 'SWE', 1),
('Schweiz', 'CH', 'CHE', 1),
('Syrian Arab Republic', 'SY', 'SYR', 1),
('Taiwan', 'TW', 'TWN', 1),
('Tajikistan', 'TJ', 'TJK', 1),
('Tanzania, United Republic of', 'TZ', 'TZA', 1),
('Thailand', 'TH', 'THA', 1),
('Togo', 'TG', 'TGO', 1),
('Tokelau', 'TK', 'TKL', 1),
('Tonga', 'TO', 'TON', 1),
('Tunesien', 'TN', 'TUN', 1),
('Türkei', 'TR', 'TUR', 1),
('Turkmenistan', 'TM', 'TKM', 1),
('Tuvalu', 'TV', 'TUV', 1),
('Uganda', 'UG', 'UGA', 1),
('Ukraine', 'UA', 'UKR', 1),
('United Arab Emirates', 'AE', 'ARE', 1),
('United Kingdom', 'GB', 'GBR', 1),
('United States', 'US', 'USA', 1),
('United States Minor Outlying Islands', 'UM', 'UMI', 1),
('Uruguay', 'UY', 'URY', 1),
('Uzbekistan', 'UZ', 'UZB', 1),
('Vanuatu', 'VU', 'VUT', 1),
('Vatican City State (Holy See)', 'VA', 'VAT', 1),
('Venezuela', 'VE', 'VEN', 1),
('Vietnam', 'VN', 'VNM', 1),
('Western Sahara', 'EH', 'ESH', 1),
('Yemen', 'YE', 'YEM', 1),
('Democratic Republic of Congo', 'CD', 'COD', 1),
('Zambia', 'ZM', 'ZMB', 1),
('Zimbabwe', 'ZW', 'ZWE', 1),
('Montenegro', 'ME', 'MNE', 1),
('Serbien', 'RS', 'SRB', 1),
('Aaland Islands', 'AX', 'ALA', 1),
('Curacao', 'CW', 'CUW', 1),
('Palestinian Territory, Occupied', 'PS', 'PSE', 1),
('South Sudan', 'SS', 'SSD', 1),
('St. Barthelemy', 'BL', 'BLM', 1),
('St. Martin (French part)', 'MF', 'MAF', 1),
('Canary Islands', 'IC', 'ICA', 1),
('Ascension Island (British)', 'AC', 'ASC', 1),
('Kosovo, Republic of', 'XK', 'UNK', 1),
('Isle of Man', 'IM', 'IMN', 1),
('Tristan da Cunha', 'TA', 'SHN', 1),
('Guernsey', 'GG', 'GGY', 1),
('Jersey', 'JE', 'JEY', 1);


/* Berechtigungen */
INSERT INTO berechtigungen(berechtigung_name, berechtigung_identifier, berechtigung_beschreibung) VALUES ('Benutzerverwaltung','EDIT_BENUTZER','Erlaubt es dem Anwender die Benutzer der App zu verwalten.');
INSERT INTO berechtigungen(berechtigung_name, berechtigung_identifier, berechtigung_beschreibung) VALUES ('Messenverwaltung','EDIT_MESSEN','Erlaubt es dem Anwender die Messen zu verwalten.');
INSERT INTO berechtigungen(berechtigung_name, berechtigung_identifier, berechtigung_beschreibung) VALUES ('Aktionsverwaltung','EDIT_AKTIONEN','Erlaubt es dem Anwender die Aktionen zu verwalten.');
INSERT INTO berechtigungen(berechtigung_name, berechtigung_identifier, berechtigung_beschreibung) VALUES ('Empfängerverwaltung','EDIT_EMPFÄNGER','Erlaubt es dem Anwender die benutzerdefinierten Empfänger für die Aktionen zu verwalten.');
INSERT INTO berechtigungen(berechtigung_name, berechtigung_identifier, berechtigung_beschreibung) VALUES ('Custom Felder verwalten','EDIT_CUSTOM_FELDER','Erlaubt es dem Anwender die Custom Felder zu verwalten.');
INSERT INTO berechtigungen(berechtigung_name, berechtigung_identifier, berechtigung_beschreibung) VALUES ('Gesperrte Seiten','EDIT_GESPERRTE_SEITEN','Erlaubt es dem Anwender durch andere Benutzer gesperrte Seiten freizugeben.');
INSERT INTO berechtigungen(berechtigung_name, berechtigung_identifier, berechtigung_beschreibung) VALUES ('Notizen verwalten','EDIT_NOTIZEN','Erlaubt es dem Anwender unabhängig vom User Notizen zu bearbeiten und zu löschen.');