#include "pch.h"
#include "Uhr.h"
#include <iostream>

#include "Form1.h"
using namespace CppCLRWinformsProjekt;

Uhr::Uhr()
{
	workthread = NULL;
	uhrLaeuft = false;
	minuten = 0;
	sekunden = 0;
	modus = Stellmodus;
	pausiert = false;
}

void Uhr::Update()
{
	while (uhrLaeuft)
	{
		_sleep(1000);
		if (!pausiert)
		{

			switch (modus)
			{
			case Stellmodus:
				break;
			case Stopuhrmodus:
				sekunden++;
				if (sekunden == 60)
				{
					minuten++;
					sekunden = 0;
				}

				break;
			case Eieruhrmodus:
				if (sekunden > 0 || minuten > 0)
				{
					sekunden--;
					if (sekunden < 0)
					{

						if (minuten > 0)
						{
							minuten--;
							sekunden = 59;
						}
					}
				}
				break;
			default:
				break;
			}

			if ((minuten == 59 && sekunden == 59) || (minuten == 0 && sekunden == 0))
			{
				//ALARM
			}

			Form1::uhrLabel->Invoke(Form1::anzeigeDelegate, minuten, sekunden);

		}

	}

}



void Uhr::Start()
{
	if (uhrLaeuft)
	{
		pausiert = false;
		return;
	}

	if (minuten == 0 && sekunden == 0)
		modus = Stopuhrmodus;
	else
		modus = Eieruhrmodus;

	uhrLaeuft = true;




	Uhr* currentUhr = this;
	workthread = new thread(&Uhr::Update, currentUhr);
	workthread->detach();

}


void Uhr::Pause()
{
	pausiert = true;
}
void Uhr::Stopp()
{
	uhrLaeuft = false;
}