#include "Sparbuch.h"

Sparbuch::Sparbuch(long bnr, char *inh, char *kwt)
{
    this->buchnummer = bnr;
    //cout << "DEBUG: " << this->buchnummer << endl;
    this->inhaber = new char[strlen(inh) + 1];
    strcpy(this->inhaber, inh);

    if(strcmp(kwt, "-") != 0)
    {
        this->kennwort = new char[strlen(kwt) + 1];
        strcpy(this->kennwort, kwt);
    }
    else
    {
        this->kennwort = NULL;
    }
}
Sparbuch::Sparbuch(const Sparbuch &buch)
{
    this->buchnummer = buch.buchnummer;
    this->inhaber = new char[strlen(buch.inhaber) + 1];
    strcpy(this->inhaber, buch.inhaber);

    if(buch.kennwort == NULL)
        this->kennwort = NULL;
    else
    {
        this->kennwort = new char[strlen(buch.kennwort) + 1];
        strcpy(this->kennwort, buch.kennwort);
    }
}
Sparbuch::Sparbuch()
{
    this->inhaber = NULL;
    this->kennwort = NULL;
}
Sparbuch::~Sparbuch()
{
    delete[] inhaber;
    delete[] kennwort;
}
Sparbuch& Sparbuch::operator=(const Sparbuch &s)
{
    if(this->kennwort != NULL)
        delete[] this->kennwort;

    if(this->inhaber != NULL)
        delete[] this->inhaber;

    this->inhaber = new char[strlen(s.inhaber)];
    strcpy(this->inhaber, s.inhaber);

    this->buchnummer = s.buchnummer;

    if(s.kennwort != NULL)
    {
        this->kennwort = new char[strlen(s.kennwort)];
        strcpy(this->kennwort, s.kennwort);
    }
    else
        this->kennwort = NULL;

    return *this;
}
char*::Sparbuch::getInhaber()
{
    return this->inhaber;
}
void Sparbuch::zeigeDaten()
{
    cout << "Buchnummer: " << this->buchnummer << endl;
    cout << "Inhaber: " << this->inhaber << endl;
    if(this->kennwort != NULL)
        cout << "Kennwort: " << this->kennwort << endl;
    else
        cout << "Kennwort: " << "-" << endl;

    cout << endl;
}

