#include "Bank.h"

Bank::Bank()
{
    this->konten = NULL;
    this->anzahlKonten = 0;
}

Bank::~Bank()
{
    delete[] this->konten;
}

void Bank::zeigeKonten()
{
    for(int i = 0; i < anzahlKonten; i++)
    {
        konten[i].zeigeDaten();
    }
}

void Bank::zeigeKonten(char *inhaber)
{
    for(int i = 0; i < anzahlKonten; i++)
    {
        if(strcmp(konten[i].getInhaber(), inhaber) == 0)
        {
            konten[i].zeigeDaten();
        }
    }
}

void Bank::sparbuchAufloesen(int index)
{
    if(anzahlKonten < 1 || index > (anzahlKonten - 1) || index < 0)
        return;

    anzahlKonten--;
    Sparbuch* tmpKonten = new Sparbuch[anzahlKonten];

    int alterMaxIndex = anzahlKonten;

    // Erst wird alles vor dme Index kopiert
    for(int i = 0; i < index; i++)
    {
        tmpKonten[i] = konten[i];
    }
    // Dann alles danach
    for(int i = index + 1; i < anzahlKonten + 1; i++)
    {
        tmpKonten[i - 1] = konten[i];
    }

    delete[] konten;
    konten = tmpKonten;
}

void Bank::sparbuchAnlegen()
{
    long kontonummer = 0;
    cout << "Bitte geben Sie die Kontonummer ein: ";
    cin >> kontonummer;
    char* inhaber = new char[256];
    cout << "Geben Sie den Namen des Kontoinhabers ein: ";
    cin >> inhaber;

    char option = 'K';
    while(option != 'Y' && option != 'N')
    {
        cout << "Soll das Konto ein Passwort haben? (Y/N) " << endl;
        cin >> option;
        option = toupper(option);
    }

    char* kennwort = new char[256];
    strcpy(kennwort, "-"); // Wir gehen von keinem Passwort aus

    bool abbruch = false;

    if(option == 'Y')
    {
        cout << "Kennwort eingeben:";
        cin >> kennwort;
        char* tmpKennwort = new char[256];
        cout << "Kennwort wiederholen:";
        cin >> tmpKennwort;
        if(strcmp(kennwort, tmpKennwort) != 0)
        {
            cout << "Die Passwoerter stimmen nicht ueberein! Vorgang wird abgebrochen!" << endl;
            abbruch = true;
        }

        delete[] tmpKennwort;
    }

    if(abbruch)
    {
        delete[] kennwort;
        delete[] inhaber;
        cout << endl;
        return;
    }
    else
    {
        anzahlKonten++;
        Sparbuch* tmpKonten = new Sparbuch[anzahlKonten];
        for(int i = 0; i < anzahlKonten - 1; i++)
        {
            tmpKonten[i] = konten[i];
        }

        delete[] konten;
        tmpKonten[anzahlKonten - 1] = Sparbuch(kontonummer, inhaber, kennwort);
        konten = tmpKonten;
        delete[] inhaber;
        delete[] kennwort;
        cout << endl;
    }

}


