#include "pkwmitahk.h"
#include "Anhaenger.h"
#include <iostream>

using namespace std;

PKWmitAHK::PKWmitAHK(string hersteller, string modell) : PKW::PKW(hersteller, modell)
{
    meinAnhaenger = NULL;

}
PKWmitAHK::~PKWmitAHK()
{
    delete meinAnhaenger;
}

void PKWmitAHK::abhaengen()
{
    if(meinAnhaenger != NULL)
    {
        zuladung -= meinAnhaenger->getAchslast();
        delete meinAnhaenger;
        meinAnhaenger = NULL;
    }
}

bool PKWmitAHK::anhaengen(Anhaenger * hptr)
{
    if(meinAnhaenger != NULL)
        return false;
    else
    {
        meinAnhaenger = hptr;
        zuladung += meinAnhaenger->getAchslast();
        return true;
    }
}

void PKWmitAHK::bremsen()
{
    if(meinAnhaenger != NULL)
    {
        meinAnhaenger->bremsen();
    }

    cout << "PKW bremst!" << endl;
}

void PKWmitAHK::zeigeDaten()
{
    cout << endl;
    cout << "Daten von PKW Nr   : " << nr << endl;
    cout << "Hertseller         : " << hersteller << endl;
    cout << "Modell             : " << modell << endl;
    cout << "Zuladung           : " << zuladung << " kg" << endl;
    cout << "Anhaengerkupplung  : " << (meinAnhaenger == NULL ? "vorhanden" : "belegt")  << endl;

}
